/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.stm;

import groovy.lang.Closure;
import groovyx.gpars.stm.GParsAtomicBooleanBlock;
import groovyx.gpars.stm.GParsAtomicDoubleBlock;
import groovyx.gpars.stm.GParsAtomicIntBlock;
import groovyx.gpars.stm.GParsAtomicLongBlock;
import groovyx.gpars.stm.GParsAtomicVoidBlock;
import groovyx.gpars.stm.GParsTxnExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.TxnExecutor;
import org.multiverse.api.TxnFactoryBuilder;
import org.multiverse.api.callables.TxnBooleanCallable;
import org.multiverse.api.callables.TxnDoubleCallable;
import org.multiverse.api.callables.TxnIntCallable;
import org.multiverse.api.callables.TxnLongCallable;
import org.multiverse.api.callables.TxnVoidCallable;
import org.multiverse.api.exceptions.ControlFlowError;

public abstract class GParsStm {
    static final String THE_CODE_FOR_AN_ATOMIC_BLOCK_MUST_NOT_BE_NULL = "The code for an atomic block must not be null.";
    static final String AN_EXCEPTION_WAS_EXPECTED_TO_BE_THROWN_FROM_UNWRAP_STM_CONTROL_ERROR_FOR = "An exception was expected to be thrown from unwrapStmControlError for ";
    private static final String CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED = "Cannot create an atomic block. Some of the specified parameters are not supported. ";
    public static final TxnFactoryBuilder transactionFactory = GlobalStmInstance.getGlobalStmInstance().newTxnFactoryBuilder();
    private static TxnExecutor defaultTxnExecutor = GlobalStmInstance.getGlobalStmInstance().newTxnFactoryBuilder().setFamilyName("GPars.Stm").newTxnExecutor();

    public static TxnExecutor createTxnExecutor() {
        return GParsStm.createTxnExecutor(Collections.<String, Object>emptyMap());
    }

    public static TxnExecutor createTxnExecutor(Map<String, Object> params) {
        TxnFactoryBuilder localFactory = transactionFactory;
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Cannot create an atomic block. The value for " + entry.getKey() + " is null.");
            }
            if (entry.getKey() == null || "".equals(entry.getKey().trim())) {
                throw new IllegalArgumentException("Cannot create an atomic block. Found an empty key.");
            }
            String key = "set" + Character.toUpperCase(entry.getKey().charAt(0)) + entry.getKey().substring(1);
            try {
                Method method = entry.getValue().getClass().equals(Long.class) ? TxnFactoryBuilder.class.getDeclaredMethod(key, Long.TYPE) : (entry.getValue().getClass().equals(Integer.class) ? TxnFactoryBuilder.class.getDeclaredMethod(key, Integer.TYPE) : (entry.getValue().getClass().equals(Boolean.class) ? TxnFactoryBuilder.class.getDeclaredMethod(key, Boolean.TYPE) : TxnFactoryBuilder.class.getDeclaredMethod(key, entry.getValue().getClass())));
                localFactory = (TxnFactoryBuilder)method.invoke((Object)localFactory, entry.getValue());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
        }
        return localFactory.newTxnExecutor();
    }

    public static <T> T atomic(Closure code) {
        return (T)defaultTxnExecutor.execute(new GParsTxnExecutor(code));
    }

    public static <T> T atomic(TxnExecutor block, Closure code) {
        return (T)block.execute(new GParsTxnExecutor(code));
    }

    public static int atomicWithInt(Closure code) {
        return defaultTxnExecutor.execute((TxnIntCallable)new GParsAtomicIntBlock(code));
    }

    public static int atomicWithInt(TxnExecutor block, Closure code) {
        return block.execute((TxnIntCallable)new GParsAtomicIntBlock(code));
    }

    public static long atomicWithLong(Closure code) {
        return defaultTxnExecutor.execute((TxnLongCallable)new GParsAtomicLongBlock(code));
    }

    public static long atomicWithLong(TxnExecutor block, Closure code) {
        return block.execute((TxnLongCallable)new GParsAtomicLongBlock(code));
    }

    public static boolean atomicWithBoolean(Closure code) {
        return defaultTxnExecutor.execute((TxnBooleanCallable)new GParsAtomicBooleanBlock(code));
    }

    public static boolean atomicWithBoolean(TxnExecutor block, Closure code) {
        return block.execute((TxnBooleanCallable)new GParsAtomicBooleanBlock(code));
    }

    public static double atomicWithDouble(Closure code) {
        return defaultTxnExecutor.execute((TxnDoubleCallable)new GParsAtomicDoubleBlock(code));
    }

    public static double atomicWithDouble(TxnExecutor block, Closure code) {
        return block.execute((TxnDoubleCallable)new GParsAtomicDoubleBlock(code));
    }

    public static void atomicWithVoid(Closure code) {
        defaultTxnExecutor.execute((TxnVoidCallable)new GParsAtomicVoidBlock(code));
    }

    public static void atomicWithVoid(TxnExecutor block, Closure code) {
        block.execute((TxnVoidCallable)new GParsAtomicVoidBlock(code));
    }

    static void unwrapStmControlError(InvokerInvocationException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ControlFlowError) {
            throw (Error)cause;
        }
        throw e;
    }
}

