/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.xml.IPostProcessor;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.internal.XmlSuiteUtils;

class JarFileUtils {
    private final IPostProcessor processor;
    private final String xmlPathInJar;
    private final List<String> testNames;
    private final List<XmlSuite> suites = Lists.newLinkedList();

    JarFileUtils(IPostProcessor iPostProcessor, String string, List<String> list) {
        this.processor = iPostProcessor;
        this.xmlPathInJar = string;
        this.testNames = list;
    }

    List<XmlSuite> extractSuitesFrom(File file) {
        try {
            Utils.log("TestNG", 2, "Trying to open jar file:" + file);
            List<String> list = Lists.newArrayList();
            boolean bl = this.testngXmlExistsInJar(file, list);
            if (!bl) {
                Utils.log("TestNG", 1, "Couldn't find the " + this.xmlPathInJar + " in the jar file, running all the classes");
                this.suites.add(XmlSuiteUtils.newXmlSuiteUsing(list));
            }
        }
        catch (IOException iOException) {
            throw new TestNGException(iOException);
        }
        return this.suites;
    }

    private boolean testngXmlExistsInJar(File file, List<String> list) throws IOException {
        boolean bl = false;
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (this.matchesXmlPathInJar(jarEntry)) {
                    Collection<XmlSuite> collection = Parser.parse(jarFile.getInputStream(jarEntry), this.processor);
                    Iterator<XmlSuite> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        XmlSuite xmlSuite;
                        XmlSuite xmlSuite2 = xmlSuite = iterator.next();
                        if (this.testNames != null) {
                            xmlSuite2 = XmlSuiteUtils.cloneIfContainsTestsWithNamesMatchingAny(xmlSuite, this.testNames);
                        }
                        this.suites.add(xmlSuite2);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                if (!JarFileUtils.isJavaClass(jarEntry)) continue;
                list.add(JarFileUtils.constructClassName(jarEntry));
            }
        }
        return bl;
    }

    private boolean matchesXmlPathInJar(JarEntry jarEntry) {
        return jarEntry.getName().equals(this.xmlPathInJar);
    }

    private static boolean isJavaClass(JarEntry jarEntry) {
        return jarEntry.getName().endsWith(".class");
    }

    private static String constructClassName(JarEntry jarEntry) {
        int n = jarEntry.getName().length() - ".class".length();
        return jarEntry.getName().replace("/", ".").substring(0, n);
    }
}

