/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014,2015,2017,2018, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_128_fma_double kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/gmxlib/nrnb.h"

#include "kernelutil_x86_avx_128_fma_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecRF_VdwLJ_GeomW3W3_VF_avx_128_fma_double
 * Electrostatics interaction: ReactionField
 * VdW interaction:            LennardJones
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecRF_VdwLJ_GeomW3W3_VF_avx_128_fma_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     struct t_forcerec           * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128d          dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128d          one_sixth   = _mm_set1_pd(1.0/6.0);
    __m128d          one_twelfth = _mm_set1_pd(1.0/12.0);
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->ic->epsfac);
    charge           = mdatoms->chargeA;
    krf              = _mm_set1_pd(fr->ic->k_rf);
    krf2             = _mm_set1_pd(fr->ic->k_rf*2.0);
    crf              = _mm_set1_pd(fr->ic->c_rf);
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+0]));
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq0              = _mm_set1_pd(charge[inr+0]);
    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    qq00             = _mm_mul_pd(iq0,jq0);
    c6_00            = _mm_set1_pd(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = _mm_set1_pd(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq01             = _mm_mul_pd(iq0,jq1);
    qq02             = _mm_mul_pd(iq0,jq2);
    qq10             = _mm_mul_pd(iq1,jq0);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq20             = _mm_mul_pd(iq2,jq0);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();

        /* Reset potential sums */
        velecsum         = _mm_setzero_pd();
        vvdwsum          = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = avx128fma_invsqrt_d(rsq00);
            rinv01           = avx128fma_invsqrt_d(rsq01);
            rinv02           = avx128fma_invsqrt_d(rsq02);
            rinv10           = avx128fma_invsqrt_d(rsq10);
            rinv11           = avx128fma_invsqrt_d(rsq11);
            rinv12           = avx128fma_invsqrt_d(rsq12);
            rinv20           = avx128fma_invsqrt_d(rsq20);
            rinv21           = avx128fma_invsqrt_d(rsq21);
            rinv22           = avx128fma_invsqrt_d(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq00,_mm_sub_pd(_mm_macc_pd(krf,rsq00,rinv00),crf));
            felec            = _mm_mul_pd(qq00,_mm_msub_pd(rinv00,rinvsq00,krf2));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm_mul_pd(c12_00,_mm_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm_msub_pd( vvdw12,one_twelfth, _mm_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm_mul_pd(_mm_sub_pd(vvdw12,vvdw6),rinvsq00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);
            vvdwsum          = _mm_add_pd(vvdwsum,vvdw);

            fscal            = _mm_add_pd(felec,fvdw);

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx00,fscal,fix0);
            fiy0             = _mm_macc_pd(dy00,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz00,fscal,fiz0);
            
            fjx0             = _mm_macc_pd(dx00,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy00,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq01,_mm_sub_pd(_mm_macc_pd(krf,rsq01,rinv01),crf));
            felec            = _mm_mul_pd(qq01,_mm_msub_pd(rinv01,rinvsq01,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx01,fscal,fix0);
            fiy0             = _mm_macc_pd(dy01,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz01,fscal,fiz0);
            
            fjx1             = _mm_macc_pd(dx01,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy01,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz01,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq02,_mm_sub_pd(_mm_macc_pd(krf,rsq02,rinv02),crf));
            felec            = _mm_mul_pd(qq02,_mm_msub_pd(rinv02,rinvsq02,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx02,fscal,fix0);
            fiy0             = _mm_macc_pd(dy02,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz02,fscal,fiz0);
            
            fjx2             = _mm_macc_pd(dx02,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy02,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz02,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(_mm_macc_pd(krf,rsq10,rinv10),crf));
            felec            = _mm_mul_pd(qq10,_mm_msub_pd(rinv10,rinvsq10,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx10,fscal,fix1);
            fiy1             = _mm_macc_pd(dy10,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz10,fscal,fiz1);
            
            fjx0             = _mm_macc_pd(dx10,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy10,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz10,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(_mm_macc_pd(krf,rsq11,rinv11),crf));
            felec            = _mm_mul_pd(qq11,_mm_msub_pd(rinv11,rinvsq11,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(_mm_macc_pd(krf,rsq12,rinv12),crf));
            felec            = _mm_mul_pd(qq12,_mm_msub_pd(rinv12,rinvsq12,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(_mm_macc_pd(krf,rsq20,rinv20),crf));
            felec            = _mm_mul_pd(qq20,_mm_msub_pd(rinv20,rinvsq20,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx20,fscal,fix2);
            fiy2             = _mm_macc_pd(dy20,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz20,fscal,fiz2);
            
            fjx0             = _mm_macc_pd(dx20,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy20,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz20,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(_mm_macc_pd(krf,rsq21,rinv21),crf));
            felec            = _mm_mul_pd(qq21,_mm_msub_pd(rinv21,rinvsq21,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(_mm_macc_pd(krf,rsq22,rinv22),crf));
            felec            = _mm_mul_pd(qq22,_mm_msub_pd(rinv22,rinvsq22,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 327 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = avx128fma_invsqrt_d(rsq00);
            rinv01           = avx128fma_invsqrt_d(rsq01);
            rinv02           = avx128fma_invsqrt_d(rsq02);
            rinv10           = avx128fma_invsqrt_d(rsq10);
            rinv11           = avx128fma_invsqrt_d(rsq11);
            rinv12           = avx128fma_invsqrt_d(rsq12);
            rinv20           = avx128fma_invsqrt_d(rsq20);
            rinv21           = avx128fma_invsqrt_d(rsq21);
            rinv22           = avx128fma_invsqrt_d(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq00,_mm_sub_pd(_mm_macc_pd(krf,rsq00,rinv00),crf));
            felec            = _mm_mul_pd(qq00,_mm_msub_pd(rinv00,rinvsq00,krf2));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm_mul_pd(c12_00,_mm_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm_msub_pd( vvdw12,one_twelfth, _mm_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm_mul_pd(_mm_sub_pd(vvdw12,vvdw6),rinvsq00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);
            vvdw             = _mm_unpacklo_pd(vvdw,_mm_setzero_pd());
            vvdwsum          = _mm_add_pd(vvdwsum,vvdw);

            fscal            = _mm_add_pd(felec,fvdw);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx00,fscal,fix0);
            fiy0             = _mm_macc_pd(dy00,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz00,fscal,fiz0);
            
            fjx0             = _mm_macc_pd(dx00,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy00,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq01,_mm_sub_pd(_mm_macc_pd(krf,rsq01,rinv01),crf));
            felec            = _mm_mul_pd(qq01,_mm_msub_pd(rinv01,rinvsq01,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx01,fscal,fix0);
            fiy0             = _mm_macc_pd(dy01,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz01,fscal,fiz0);
            
            fjx1             = _mm_macc_pd(dx01,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy01,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz01,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq02,_mm_sub_pd(_mm_macc_pd(krf,rsq02,rinv02),crf));
            felec            = _mm_mul_pd(qq02,_mm_msub_pd(rinv02,rinvsq02,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx02,fscal,fix0);
            fiy0             = _mm_macc_pd(dy02,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz02,fscal,fiz0);
            
            fjx2             = _mm_macc_pd(dx02,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy02,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz02,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(_mm_macc_pd(krf,rsq10,rinv10),crf));
            felec            = _mm_mul_pd(qq10,_mm_msub_pd(rinv10,rinvsq10,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx10,fscal,fix1);
            fiy1             = _mm_macc_pd(dy10,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz10,fscal,fiz1);
            
            fjx0             = _mm_macc_pd(dx10,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy10,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz10,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(_mm_macc_pd(krf,rsq11,rinv11),crf));
            felec            = _mm_mul_pd(qq11,_mm_msub_pd(rinv11,rinvsq11,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(_mm_macc_pd(krf,rsq12,rinv12),crf));
            felec            = _mm_mul_pd(qq12,_mm_msub_pd(rinv12,rinvsq12,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(_mm_macc_pd(krf,rsq20,rinv20),crf));
            felec            = _mm_mul_pd(qq20,_mm_msub_pd(rinv20,rinvsq20,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx20,fscal,fix2);
            fiy2             = _mm_macc_pd(dy20,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz20,fscal,fiz2);
            
            fjx0             = _mm_macc_pd(dx20,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy20,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz20,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(_mm_macc_pd(krf,rsq21,rinv21),crf));
            felec            = _mm_mul_pd(qq21,_mm_msub_pd(rinv21,rinvsq21,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(_mm_macc_pd(krf,rsq22,rinv22),crf));
            felec            = _mm_mul_pd(qq22,_mm_msub_pd(rinv22,rinvsq22,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 327 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm_update_1pot_pd(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 20 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3W3_VF,outeriter*20 + inneriter*327);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecRF_VdwLJ_GeomW3W3_F_avx_128_fma_double
 * Electrostatics interaction: ReactionField
 * VdW interaction:            LennardJones
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecRF_VdwLJ_GeomW3W3_F_avx_128_fma_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     struct t_forcerec           * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128d          dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128d          one_sixth   = _mm_set1_pd(1.0/6.0);
    __m128d          one_twelfth = _mm_set1_pd(1.0/12.0);
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->ic->epsfac);
    charge           = mdatoms->chargeA;
    krf              = _mm_set1_pd(fr->ic->k_rf);
    krf2             = _mm_set1_pd(fr->ic->k_rf*2.0);
    crf              = _mm_set1_pd(fr->ic->c_rf);
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+0]));
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq0              = _mm_set1_pd(charge[inr+0]);
    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    qq00             = _mm_mul_pd(iq0,jq0);
    c6_00            = _mm_set1_pd(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = _mm_set1_pd(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq01             = _mm_mul_pd(iq0,jq1);
    qq02             = _mm_mul_pd(iq0,jq2);
    qq10             = _mm_mul_pd(iq1,jq0);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq20             = _mm_mul_pd(iq2,jq0);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = avx128fma_invsqrt_d(rsq00);
            rinv01           = avx128fma_invsqrt_d(rsq01);
            rinv02           = avx128fma_invsqrt_d(rsq02);
            rinv10           = avx128fma_invsqrt_d(rsq10);
            rinv11           = avx128fma_invsqrt_d(rsq11);
            rinv12           = avx128fma_invsqrt_d(rsq12);
            rinv20           = avx128fma_invsqrt_d(rsq20);
            rinv21           = avx128fma_invsqrt_d(rsq21);
            rinv22           = avx128fma_invsqrt_d(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq00,_mm_msub_pd(rinv00,rinvsq00,krf2));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            fvdw             = _mm_mul_pd(_mm_msub_pd(c12_00,rinvsix,c6_00),_mm_mul_pd(rinvsix,rinvsq00));

            fscal            = _mm_add_pd(felec,fvdw);

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx00,fscal,fix0);
            fiy0             = _mm_macc_pd(dy00,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz00,fscal,fiz0);
            
            fjx0             = _mm_macc_pd(dx00,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy00,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq01,_mm_msub_pd(rinv01,rinvsq01,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx01,fscal,fix0);
            fiy0             = _mm_macc_pd(dy01,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz01,fscal,fiz0);
            
            fjx1             = _mm_macc_pd(dx01,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy01,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz01,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq02,_mm_msub_pd(rinv02,rinvsq02,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx02,fscal,fix0);
            fiy0             = _mm_macc_pd(dy02,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz02,fscal,fiz0);
            
            fjx2             = _mm_macc_pd(dx02,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy02,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz02,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq10,_mm_msub_pd(rinv10,rinvsq10,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx10,fscal,fix1);
            fiy1             = _mm_macc_pd(dy10,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz10,fscal,fiz1);
            
            fjx0             = _mm_macc_pd(dx10,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy10,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz10,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq11,_mm_msub_pd(rinv11,rinvsq11,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq12,_mm_msub_pd(rinv12,rinvsq12,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq20,_mm_msub_pd(rinv20,rinvsq20,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx20,fscal,fix2);
            fiy2             = _mm_macc_pd(dy20,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz20,fscal,fiz2);
            
            fjx0             = _mm_macc_pd(dx20,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy20,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz20,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq21,_mm_msub_pd(rinv21,rinvsq21,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq22,_mm_msub_pd(rinv22,rinvsq22,krf2));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 277 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = avx128fma_invsqrt_d(rsq00);
            rinv01           = avx128fma_invsqrt_d(rsq01);
            rinv02           = avx128fma_invsqrt_d(rsq02);
            rinv10           = avx128fma_invsqrt_d(rsq10);
            rinv11           = avx128fma_invsqrt_d(rsq11);
            rinv12           = avx128fma_invsqrt_d(rsq12);
            rinv20           = avx128fma_invsqrt_d(rsq20);
            rinv21           = avx128fma_invsqrt_d(rsq21);
            rinv22           = avx128fma_invsqrt_d(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq00,_mm_msub_pd(rinv00,rinvsq00,krf2));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            fvdw             = _mm_mul_pd(_mm_msub_pd(c12_00,rinvsix,c6_00),_mm_mul_pd(rinvsix,rinvsq00));

            fscal            = _mm_add_pd(felec,fvdw);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx00,fscal,fix0);
            fiy0             = _mm_macc_pd(dy00,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz00,fscal,fiz0);
            
            fjx0             = _mm_macc_pd(dx00,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy00,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq01,_mm_msub_pd(rinv01,rinvsq01,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx01,fscal,fix0);
            fiy0             = _mm_macc_pd(dy01,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz01,fscal,fiz0);
            
            fjx1             = _mm_macc_pd(dx01,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy01,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz01,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq02,_mm_msub_pd(rinv02,rinvsq02,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix0             = _mm_macc_pd(dx02,fscal,fix0);
            fiy0             = _mm_macc_pd(dy02,fscal,fiy0);
            fiz0             = _mm_macc_pd(dz02,fscal,fiz0);
            
            fjx2             = _mm_macc_pd(dx02,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy02,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz02,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq10,_mm_msub_pd(rinv10,rinvsq10,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx10,fscal,fix1);
            fiy1             = _mm_macc_pd(dy10,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz10,fscal,fiz1);
            
            fjx0             = _mm_macc_pd(dx10,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy10,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz10,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq11,_mm_msub_pd(rinv11,rinvsq11,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq12,_mm_msub_pd(rinv12,rinvsq12,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq20,_mm_msub_pd(rinv20,rinvsq20,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx20,fscal,fix2);
            fiy2             = _mm_macc_pd(dy20,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz20,fscal,fiz2);
            
            fjx0             = _mm_macc_pd(dx20,fscal,fjx0);
            fjy0             = _mm_macc_pd(dy20,fscal,fjy0);
            fjz0             = _mm_macc_pd(dz20,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq21,_mm_msub_pd(rinv21,rinvsq21,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_pd(qq22,_mm_msub_pd(rinv22,rinvsq22,krf2));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 277 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3W3_F,outeriter*18 + inneriter*277);
}
