/*
 * Copyright 2007-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 */

package griffon.samples.swingpad

import griffon.transform.Threading

import java.awt.Window

/**
 * @author Andres Almiray
 */
class DialogController {
    def model
    def view
    def builder

    protected dialog

    @Threading(Threading.Policy.INSIDE_UITHREAD_SYNC)
    def show = { Window window = null ->
        window = window ?: Window.windows.find {it.focused}
        if (!dialog || dialog.owner != window) {
            dialog = builder.dialog(
                    owner: window,
                    title: model.title,
                    resizable: model.resizable,
                    modal: model.modal) {
                container(view.content)
            }
            if (model.width > 0 && model.height > 0) {
                dialog.preferredSize = [model.width, model.height]
            }
            dialog.pack()
        }
        int x = window.x + (window.width - dialog.width) / 2
        int y = window.y + (window.height - dialog.height) / 2
        dialog.setLocation(x, y)
        dialog.visible = true
    }

    @Threading(Threading.Policy.INSIDE_UITHREAD_SYNC)
    def hide = { evt = null ->
        dialog?.visible = false
        dialog?.dispose()
        dialog = null
    }
}
