/*
 * Copyright 2010-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.griffon.runtime.core;

import griffon.core.ThreadingHandler;
import griffon.core.UIThreadManager;
import groovy.lang.Closure;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * Base implementation of the ThreadingHandler interface.
 *
 * @author Andres Almiray
 * @since 0.9.3
 */
public abstract class AbstractThreadingHandler implements ThreadingHandler {
    public boolean isUIThread() {
        return UIThreadManager.getInstance().isUIThread();
    }

    public void execInsideUIAsync(Runnable runnable) {
        UIThreadManager.getInstance().executeAsync(runnable);
    }


    public void execInsideUISync(Runnable runnable) {
        UIThreadManager.getInstance().executeSync(runnable);
    }

    public void execOutsideUI(Runnable runnable) {
        UIThreadManager.getInstance().executeOutside(runnable);
    }

    public <R> Future<R> execFuture(ExecutorService executorService, Closure<R> closure) {
        return UIThreadManager.getInstance().executeFuture(executorService, closure);
    }

    public <R> Future<R> execFuture(Closure<R> closure) {
        return UIThreadManager.getInstance().executeFuture(closure);
    }

    public <R> Future<R> execFuture(ExecutorService executorService, Callable<R> callable) {
        return UIThreadManager.getInstance().executeFuture(executorService, callable);
    }

    public <R> Future<R> execFuture(Callable<R> callable) {
        return UIThreadManager.getInstance().executeFuture(callable);
    }
}
