/*
 * Copyright 2010-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package griffon.core.resources.editors;

import java.beans.PropertyEditorSupport;

/**
 * @author Andres Almiray
 * @since 1.1.0
 */
public abstract class AbstractPropertyEditor extends PropertyEditorSupport {
    protected IllegalArgumentException illegalValue(Object value, Class klass) {
        throw new IllegalArgumentException("Cannot convert '" + value + "' into " + klass.getName());
    }

    protected IllegalArgumentException illegalValue(Object value, Class klass, Exception e) {
        throw new IllegalArgumentException("Cannot convert '" + value + "' into " + klass.getName(), e);
    }
}
