/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ExecutorServiceHolder {
    private static final Set<ExecutorService> EXECUTOR_SERVICE_CACHE = new LinkedHashSet<ExecutorService>();

    public static ExecutorService add(ExecutorService executorService) {
        if (executorService != null) {
            EXECUTOR_SERVICE_CACHE.add(executorService);
        }
        return executorService;
    }

    public static ExecutorService remove(ExecutorService executorService) {
        EXECUTOR_SERVICE_CACHE.remove(executorService);
        return executorService;
    }

    public static void shutdownAll() {
        for (ExecutorService executorService : EXECUTOR_SERVICE_CACHE) {
            if (executorService.isShutdown()) continue;
            executorService.shutdownNow();
        }
    }
}

