/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.i18n;

import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageSource
implements MessageSource {
    protected static final Object[] EMPTY_OBJECT_ARGS = new Object[0];

    @Override
    public String getMessage(String key) throws NoSuchMessageException {
        return this.getMessage(key, EMPTY_OBJECT_ARGS, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, Locale locale) throws NoSuchMessageException {
        return this.getMessage(key, EMPTY_OBJECT_ARGS, locale);
    }

    @Override
    public String getMessage(String key, Object[] args) throws NoSuchMessageException {
        return this.getMessage(key, args, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, List args) throws NoSuchMessageException {
        return this.getMessage(key, this.toObjectArray(args), Locale.getDefault());
    }

    @Override
    public String getMessage(String key, List args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(key, this.toObjectArray(args), locale);
    }

    @Override
    public String getMessage(String key, String defaultMessage) {
        return this.getMessage(key, EMPTY_OBJECT_ARGS, defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, String defaultMessage, Locale locale) {
        return this.getMessage(key, EMPTY_OBJECT_ARGS, defaultMessage, locale);
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage) {
        return this.getMessage(key, args, defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage, Locale locale) {
        try {
            return this.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException nsme) {
            return null == defaultMessage ? key : defaultMessage;
        }
    }

    @Override
    public String getMessage(String key, Map<String, Object> args) throws NoSuchMessageException {
        return this.getMessage(key, args, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, Map<String, Object> args, String defaultMessage) {
        return this.getMessage(key, args, defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, Map<String, Object> args, String defaultMessage, Locale locale) {
        try {
            return this.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException nsme) {
            return null == defaultMessage ? key : defaultMessage;
        }
    }

    @Override
    public String getMessage(String key, Map<String, Object> args, Locale locale) throws NoSuchMessageException {
        String message = this.resolveMessage(key, locale);
        return this.formatMessage(message, args);
    }

    @Override
    public String getMessage(String key, List args, String defaultMessage) {
        return this.getMessage(key, this.toObjectArray(args), defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, List args, String defaultMessage, Locale locale) {
        return this.getMessage(key, this.toObjectArray(args), defaultMessage, locale);
    }

    @Override
    public String getMessage(String key, Object[] args, Locale locale) throws NoSuchMessageException {
        if (null == args) {
            args = EMPTY_OBJECT_ARGS;
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        try {
            String message = this.resolveMessage(key, locale);
            return this.formatMessage(message, args);
        }
        catch (MissingResourceException e) {
            throw new NoSuchMessageException(key, locale);
        }
    }

    protected abstract String resolveMessage(String var1, Locale var2) throws NoSuchMessageException;

    protected String formatMessage(String message, Object[] args) {
        return MessageFormat.format(message, args);
    }

    protected String formatMessage(String message, Map<String, Object> args) {
        for (Map.Entry<String, Object> variable : args.entrySet()) {
            String var = variable.getKey();
            String value = variable.getValue() != null ? variable.getValue().toString() : null;
            if (value == null) continue;
            message = message.replace("{:" + var + "}", value);
        }
        return message;
    }

    protected Object[] toObjectArray(List args) {
        if (null == args || args.isEmpty()) {
            return EMPTY_OBJECT_ARGS;
        }
        return args.toArray(new Object[args.size()]);
    }
}

