/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.EventRouter;
import griffon.core.GriffonArtifact;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventRouter
implements EventRouter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventRouter.class);
    protected static final Object[] LOCK = new Object[0];
    private boolean enabled = true;
    protected final List listeners = Collections.synchronizedList(new ArrayList());
    private final Map<Script, Binding> scriptBindings = new LinkedHashMap<Script, Binding>();
    protected final Map<String, List> closureListeners = Collections.synchronizedMap(new LinkedHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean enabled) {
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            this.enabled = enabled;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void publish(String eventName) {
        this.publish(eventName, Collections.EMPTY_LIST);
    }

    @Override
    public void publish(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        this.buildPublisher(eventName, params, "synchronously").run();
    }

    @Override
    public void publishOutsideUI(String eventName) {
        this.publishOutsideUI(eventName, Collections.EMPTY_LIST);
    }

    @Override
    public void publishOutsideUI(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        Runnable publisher = this.buildPublisher(eventName, params, "outside UI");
        this.doPublishOutsideUI(publisher);
    }

    protected abstract void doPublishOutsideUI(Runnable var1);

    @Override
    public void publishAsync(String eventName) {
        this.publishAsync(eventName, Collections.EMPTY_LIST);
    }

    @Override
    public void publishAsync(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        Runnable publisher = this.buildPublisher(eventName, params, "asynchronously");
        this.doPublishAsync(publisher);
    }

    protected abstract void doPublishAsync(Runnable var1);

    private void invokeHandler(Object handler, List params) {
        if (handler instanceof Closure) {
            ((Closure)handler).call(this.asArray(params));
        } else if (handler instanceof RunnableWithArgs) {
            ((RunnableWithArgs)handler).run(this.asArray(params));
        }
    }

    protected void fireEvent(Script script, String eventHandler, List params) {
        Object handler;
        Binding binding = this.scriptBindings.get(script);
        if (binding == null) {
            binding = new Binding();
            script.setBinding(binding);
            script.run();
            this.scriptBindings.put(script, binding);
        }
        if ((handler = binding.getVariables().get(eventHandler)) != null) {
            this.invokeHandler(handler, params);
        }
    }

    protected void fireEvent(Closure closure, String eventHandler, List params) {
        closure.call(this.asArray(params));
    }

    protected void fireEvent(RunnableWithArgs runnable, String eventHandler, List params) {
        runnable.run(this.asArray(params));
    }

    protected void fireEvent(Object instance, String eventHandler, List params) {
        MetaClass mc = this.metaClassOf(instance);
        MetaProperty mp = mc.getMetaProperty(eventHandler);
        if (mp != null && mp.getProperty(instance) != null) {
            this.invokeHandler(mp.getProperty(instance), params);
            return;
        }
        Class[] argTypes = MetaClassHelper.convertToTypeArray((Object[])this.asArray(params));
        MetaMethod mm = mc.pickMethod(eventHandler, argTypes);
        if (mm != null) {
            mm.invoke(instance, this.asArray(params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(Object listener) {
        if (listener == null || listener instanceof Closure || listener instanceof RunnableWithArgs) {
            return;
        }
        if (listener instanceof Map) {
            this.addEventListener((Map)listener);
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                return;
            }
            try {
                LOG.debug("Adding listener " + listener);
            }
            catch (UnsupportedOperationException uoe) {
                LOG.debug("Adding listener " + listener.getClass().getName());
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void addEventListener(Map<String, Object> listener) {
        if (listener == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : listener.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Closure) {
                this.addEventListener(entry.getKey(), (Closure)value);
                continue;
            }
            if (!(value instanceof RunnableWithArgs)) continue;
            this.addEventListener(entry.getKey(), (RunnableWithArgs)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(Object listener) {
        if (listener == null || listener instanceof Closure || listener instanceof RunnableWithArgs) {
            return;
        }
        if (listener instanceof Map) {
            this.removeEventListener((Map)listener);
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Removing listener " + listener);
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.debug("Removing listener " + listener.getClass().getName());
                }
            }
            this.listeners.remove(listener);
            this.removeNestedListeners(listener);
        }
    }

    @Override
    public void removeEventListener(Map<String, Object> listener) {
        if (listener == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : listener.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Closure) {
                this.removeEventListener(entry.getKey(), (Closure)value);
                continue;
            }
            if (!(value instanceof RunnableWithArgs)) continue;
            this.removeEventListener(entry.getKey(), (RunnableWithArgs)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(String eventName, Closure listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            ArrayList<Closure> list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list == null) {
                list = new ArrayList<Closure>();
                this.closureListeners.put(GriffonNameUtils.capitalize(eventName), list);
            }
            if (list.contains(listener)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(String eventName, RunnableWithArgs listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            ArrayList<RunnableWithArgs> list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list == null) {
                list = new ArrayList<RunnableWithArgs>();
                this.closureListeners.put(GriffonNameUtils.capitalize(eventName), list);
            }
            if (list.contains(listener)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(String eventName, Closure listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            List list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                }
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(String eventName, RunnableWithArgs listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            List list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                }
                list.remove(listener);
            }
        }
    }

    protected Runnable buildPublisher(final String event, final List params, final String mode) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String eventName = GriffonNameUtils.capitalize(event);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Triggering event '" + eventName + "' " + mode);
                }
                String eventHandler = "on" + eventName;
                ArrayList listenersCopy = new ArrayList();
                Object object = AbstractEventRouter.this.listeners;
                synchronized (object) {
                    listenersCopy.addAll(AbstractEventRouter.this.listeners);
                }
                object = AbstractEventRouter.this.closureListeners;
                synchronized (object) {
                    List list = AbstractEventRouter.this.closureListeners.get(eventName);
                    if (list != null) {
                        for (Object listener : list) {
                            listenersCopy.add(listener);
                        }
                    }
                }
                for (Object listener : listenersCopy) {
                    if (listener instanceof Script) {
                        AbstractEventRouter.this.fireEvent((Script)listener, eventHandler, params);
                        continue;
                    }
                    if (listener instanceof Closure) {
                        AbstractEventRouter.this.fireEvent((Closure)listener, eventHandler, params);
                        continue;
                    }
                    if (listener instanceof RunnableWithArgs) {
                        AbstractEventRouter.this.fireEvent((RunnableWithArgs)listener, eventHandler, params);
                        continue;
                    }
                    AbstractEventRouter.this.fireEvent(listener, eventHandler, params);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNestedListeners(Object subject) {
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            for (Map.Entry<String, List> event : this.closureListeners.entrySet()) {
                String eventName = event.getKey();
                List listenerList = event.getValue();
                ArrayList toRemove = new ArrayList();
                for (Object listener : listenerList) {
                    if (!this.isNestedListener(listener, subject)) continue;
                    toRemove.add(listener);
                }
                for (Object listener : toRemove) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                    }
                    listenerList.remove(listener);
                }
            }
        }
    }

    protected boolean isNestedListener(Object listener, Object subject) {
        Class<?> listenerClass;
        if (listener instanceof Closure) {
            return ((Closure)listener).getOwner().equals(subject);
        }
        if (listener instanceof RunnableWithArgs && (listenerClass = listener.getClass()).isMemberClass() && listenerClass.getEnclosingClass().equals(subject.getClass())) {
            return subject.equals(InvokerHelper.getProperty((Object)listener, (String)"this$0"));
        }
        return false;
    }

    protected Object[] asArray(List list) {
        return list.toArray(new Object[list.size()]);
    }

    protected MetaClass metaClassOf(Object obj) {
        if (obj instanceof GriffonArtifact) {
            return ((GriffonArtifact)obj).getGriffonClass().getMetaClass();
        }
        if (obj instanceof GroovyObject) {
            return ((GroovyObject)obj).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(obj.getClass());
    }
}

