/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.AddonManager;
import griffon.core.GriffonAddon;
import griffon.core.GriffonAddonDescriptor;
import griffon.core.GriffonApplication;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddonManager
implements AddonManager {
    private final GriffonApplication app;
    private final Map<String, GriffonAddon> addons = new LinkedHashMap<String, GriffonAddon>();
    private final Map<String, GriffonAddonDescriptor> addonDescriptors = new LinkedHashMap<String, GriffonAddonDescriptor>();
    private final Object lock = new Object();
    private boolean initialized;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAddonManager.class);

    public AbstractAddonManager(GriffonApplication app) {
        this.app = app;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public Map<String, GriffonAddon> getAddons() {
        return Collections.unmodifiableMap(this.addons);
    }

    @Override
    public Map<String, GriffonAddonDescriptor> getAddonDescriptors() {
        return Collections.unmodifiableMap(this.addonDescriptors);
    }

    @Override
    public GriffonAddon findAddon(String name) {
        if (GriffonNameUtils.isBlank(name)) {
            return null;
        }
        if (name.endsWith("GriffonAddon")) {
            name = name.substring(0, name.length() - 12);
        }
        return this.addons.get(GriffonNameUtils.getPropertyName(name));
    }

    @Override
    public GriffonAddonDescriptor findAddonDescriptor(String name) {
        if (GriffonNameUtils.isBlank(name)) {
            return null;
        }
        if (name.endsWith("GriffonAddon")) {
            name = name.substring(0, name.length() - 12);
        }
        return this.addonDescriptors.get(GriffonNameUtils.getPropertyName(name));
    }

    @Override
    public Map<String, GriffonAddonDescriptor> findAddonDescriptors(String prefix) {
        if ("root".equals(prefix) || GriffonNameUtils.isBlank(prefix)) {
            prefix = "";
        }
        LinkedHashMap<String, GriffonAddonDescriptor> map = new LinkedHashMap<String, GriffonAddonDescriptor>();
        for (Map.Entry<String, GriffonAddonDescriptor> entry : this.addonDescriptors.entrySet()) {
            if (!prefix.equals(entry.getValue().getPrefix())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerAddon(GriffonAddonDescriptor addonDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                LOG.debug("Registering addon descriptor " + addonDescriptor);
                this.doRegisterAddon(addonDescriptor);
                this.addons.put(addonDescriptor.getPluginName(), addonDescriptor.getAddon());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.doInitialize();
                this.initialized = true;
            }
        }
    }

    protected abstract void doInitialize();

    protected abstract void doRegisterAddon(GriffonAddonDescriptor var1);

    protected Map<String, GriffonAddonDescriptor> getAddonsInternal() {
        return this.addonDescriptors;
    }
}

