/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.ApplicationClassLoader;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigReader;
import griffon.util.Environment;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import griffon.util.Metadata;
import groovy.util.ConfigObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String PROPERTIES_SUFFIX = "properties";
    private static final String GROOVY_SUFFIX = "groovy";

    private ConfigUtils() {
    }

    public static boolean isValueDefined(Map config, String key) {
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            if (config == null) {
                return false;
            }
            config = (Map)config.get(keys[i]);
        }
        if (config == null) {
            return false;
        }
        Object value = config.get(keys[keys.length - 1]);
        return value != null;
    }

    public static Object getConfigValue(Map config, String key) {
        return ConfigUtils.getConfigValue(config, key, null);
    }

    public static Object getConfigValue(Map config, String key, Object defaultValue) {
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            Object node;
            if (config != null) {
                node = config.get(keys[i]);
                if (!(node instanceof Map)) {
                    return defaultValue;
                }
            } else {
                return defaultValue;
            }
            config = (Map)node;
        }
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(keys[keys.length - 1]);
        return value != null ? value : defaultValue;
    }

    public static boolean getConfigValueAsBoolean(Map config, String key) {
        return ConfigUtils.getConfigValueAsBoolean(config, key, false);
    }

    public static boolean getConfigValueAsBoolean(Map config, String key, boolean defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return DefaultTypeTransformation.castToBoolean((Object)value);
    }

    public static int getConfigValueAsInt(Map config, String key) {
        return ConfigUtils.getConfigValueAsInt(config, key, 0);
    }

    public static int getConfigValueAsInt(Map config, String key, int defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return DefaultTypeTransformation.castToNumber((Object)value).intValue();
    }

    public static String getConfigValueAsString(Map config, String key) {
        return ConfigUtils.getConfigValueAsString(config, key, "");
    }

    public static String getConfigValueAsString(Map config, String key, String defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return String.valueOf(value);
    }

    public static Map merge(Map defaults, Map overrides) {
        ConfigObject configDefaults = new ConfigObject();
        ConfigObject configOverrides = new ConfigObject();
        configDefaults.putAll(defaults);
        configOverrides.putAll(overrides);
        return configDefaults.merge(configOverrides);
    }

    public static ConfigReader createConfigReader() {
        ConfigReader configReader = new ConfigReader();
        configReader.registerConditionalBlock("environments", Environment.getCurrent().getName());
        configReader.registerConditionalBlock("projects", Metadata.getCurrent().getApplicationName());
        configReader.registerConditionalBlock("platforms", GriffonApplicationUtils.getPlatform());
        return configReader;
    }

    public static ConfigObject loadConfig(String configFileName) {
        return ConfigUtils.loadConfig(ConfigUtils.createConfigReader(), ConfigUtils.safeLoadClass(configFileName), configFileName);
    }

    public static ConfigObject loadConfig(Class configClass) {
        return ConfigUtils.loadConfig(ConfigUtils.createConfigReader(), configClass, configClass.getSimpleName());
    }

    public static ConfigObject loadConfig(Class configClass, String configFileName) {
        return ConfigUtils.loadConfig(ConfigUtils.createConfigReader(), configClass, configFileName);
    }

    public static ConfigObject loadConfig(ConfigReader configReader, Class configClass, String configFileName) {
        ConfigObject config;
        block4: {
            config = new ConfigObject();
            try {
                if (configClass != null) {
                    config.merge(configReader.parse(configClass));
                }
                config.merge(ConfigUtils.loadConfigFile(configReader, configFileName));
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (Exception x) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("Cannot read configuration [class: " + configClass + ", file: " + configFileName + "]", GriffonExceptionHandler.sanitize(x));
            }
        }
        return config;
    }

    private static ConfigObject loadConfigFile(ConfigReader configReader, String configFileName) throws IOException {
        ConfigObject config = new ConfigObject();
        if (GriffonNameUtils.isBlank(configFileName)) {
            return config;
        }
        String fileNameExtension = ConfigUtils.getFilenameExtension(configFileName);
        if (GriffonNameUtils.isBlank(fileNameExtension)) {
            configFileName = configFileName + ".properties";
            fileNameExtension = PROPERTIES_SUFFIX;
        }
        if (PROPERTIES_SUFFIX.equals(fileNameExtension)) {
            InputStream is = null;
            is = configFileName.startsWith("/") ? new FileInputStream(configFileName) : ApplicationClassLoader.get().getResourceAsStream(configFileName);
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                config = configReader.parse(p);
                is.close();
            }
        } else if (GROOVY_SUFFIX.equals(fileNameExtension)) {
            String scriptText;
            InputStream is = null;
            is = configFileName.startsWith("/") ? new FileInputStream(configFileName) : ApplicationClassLoader.get().getResourceAsStream(configFileName);
            if (is != null && !GriffonNameUtils.isBlank(scriptText = DefaultGroovyMethods.getText((InputStream)is))) {
                config = configReader.parse(scriptText);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Invalid configuration [file: " + configFileName + "]. Skipping");
        }
        return config;
    }

    public static ConfigObject loadConfigWithI18n(String baseConfigFileName) {
        return ConfigUtils.loadConfigWithI18n(ApplicationHolder.getApplication().getLocale(), ConfigUtils.createConfigReader(), ConfigUtils.safeLoadClass(baseConfigFileName), baseConfigFileName);
    }

    public static ConfigObject loadConfigWithI18n(Class baseConfigClass) {
        return ConfigUtils.loadConfigWithI18n(ApplicationHolder.getApplication().getLocale(), ConfigUtils.createConfigReader(), baseConfigClass, baseConfigClass.getSimpleName());
    }

    public static ConfigObject loadConfigWithI18n(Class baseConfigClass, String baseConfigFileName) {
        return ConfigUtils.loadConfigWithI18n(ApplicationHolder.getApplication().getLocale(), ConfigUtils.createConfigReader(), baseConfigClass, baseConfigFileName);
    }

    public static ConfigObject loadConfigWithI18n(Locale locale, ConfigReader configReader, Class baseConfigClass, String baseConfigFileName) {
        ConfigObject config = ConfigUtils.loadConfig(configReader, baseConfigClass, baseConfigFileName);
        String[] combinations = new String[]{locale.getLanguage(), locale.getLanguage() + "_" + locale.getCountry(), locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant()};
        String baseClassName = baseConfigClass != null ? baseConfigClass.getName() : null;
        String fileExtension = !GriffonNameUtils.isBlank(baseConfigFileName) ? ConfigUtils.getFilenameExtension(baseConfigFileName) : null;
        for (String suffix : combinations) {
            Class configClass;
            if (GriffonNameUtils.isBlank(suffix) || suffix.endsWith("_")) continue;
            if (baseClassName != null && (configClass = ConfigUtils.safeLoadClass(baseClassName + "_" + suffix)) != null) {
                config.merge(configReader.parse(configClass));
            }
            if (fileExtension == null) continue;
            String configFileName = ConfigUtils.stripFilenameExtension(baseConfigFileName) + "_" + suffix + "." + fileExtension;
            try {
                config.merge(ConfigUtils.loadConfigFile(configReader, configFileName));
            }
            catch (FileNotFoundException fne) {
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Cannot read configuration [file: " + configFileName + "]", GriffonExceptionHandler.sanitize(e));
            }
        }
        return config;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        ClassLoader cl = ApplicationClassLoader.get();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
            cl = Thread.currentThread().getContextClassLoader();
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                cnfe = e2;
                if (cnfe != null) {
                    throw cnfe;
                }
                return null;
            }
        }
    }

    public static Class safeLoadClass(String className) {
        try {
            return ConfigUtils.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }
}

