/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.resources.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class URLPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String value) throws IllegalArgumentException {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, URL.class);
        }
    }

    private void handleAsString(String str) {
        try {
            super.setValue(new URL(str));
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(str, URL.class, e);
        }
    }

    private void handleAsFile(File file) {
        try {
            super.setValue(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(file, URL.class);
        }
    }
}

