/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.griffon.cli.shell.GriffonCommand;

public class CommandUtils {
    public static final Map<String, String> COMMAND_TO_ACTION_MAP = new LinkedHashMap<String, String>();
    private static final String PREFIX = "org.codehaus.griffon.cli.shell.command.";
    private static final String SUFFIX = "Command";

    public static GriffonCommand newAction(String scriptName) throws Exception {
        return (GriffonCommand)Class.forName(scriptName, true, CommandUtils.class.getClassLoader()).newInstance();
    }

    public static void registerCommand(String scope, String commandName, String scriptName) {
        COMMAND_TO_ACTION_MAP.put(scope + ":" + commandName, PREFIX + scriptName + SUFFIX);
    }

    public static GriffonCommand getDelegateAction(String commandName) {
        String className = COMMAND_TO_ACTION_MAP.get(commandName);
        if (className != null) {
            try {
                return CommandUtils.newAction(className);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void clearCaches() {
        COMMAND_TO_ACTION_MAP.clear();
    }
}

