/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell;

import gant.Gant;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.service.command.CommandSession;
import org.codehaus.gant.GantBinding;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.ScriptExitException;
import org.codehaus.griffon.cli.shell.AbstractGriffonShellCommand;
import org.codehaus.griffon.cli.shell.Argument;
import org.codehaus.griffon.cli.shell.GriffonCommand;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.codehaus.griffon.cli.shell.Option;
import org.codehaus.griffon.cli.shell.support.CommandArguments;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.fusesource.jansi.Ansi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GantAwareAction
extends AbstractGriffonShellCommand {
    private final String scope;
    private final String name;
    private final File scriptFile;
    private final String scriptName;
    private GriffonCommand delegateCommand;

    public GantAwareAction(String scope, String name, File scriptFile) {
        this.scope = scope;
        this.name = name;
        this.scriptFile = scriptFile;
        this.scriptName = GriffonScriptRunner.getScriptNameFromFile((File)scriptFile);
    }

    public void setDelegateCommand(GriffonCommand delegateCommand) {
        this.delegateCommand = delegateCommand;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    protected String getEnvironment() {
        String environment = this.env;
        if (this.delegateCommand != null) {
            Field field = null;
            try {
                field = this.delegateCommand.getClass().getField("env");
                field.setAccessible(true);
                environment = (String)field.get(this.delegateCommand);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                environment = this.env;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                environment = this.env;
            }
        }
        return environment;
    }

    @Override
    protected boolean getNonInteractive() {
        boolean ni = this.nonInteractive;
        if (this.delegateCommand != null) {
            Field field = null;
            try {
                field = this.delegateCommand.getClass().getField("nonInteractive");
                field.setAccessible(true);
                ni = (Boolean)field.get(this.delegateCommand);
            }
            catch (NoSuchFieldException e) {
                ni = this.nonInteractive;
            }
            catch (IllegalAccessException e) {
                ni = this.nonInteractive;
            }
        }
        return ni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute(CommandSession session, CommandArguments args) throws Exception {
        GriffonScriptRunner runner = GriffonShellContext.getGriffonScriptRunner();
        GantBinding binding = GriffonShellContext.getGantBinding();
        binding = new GantBinding();
        GriffonShellContext.setGantBinding(binding);
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        this.populateOptions(argsMap, args.options, args.subject);
        this.populateArguments(argsMap, args.orderedArguments, args.subject);
        this.setEnvironment(runner);
        binding.setVariable("unparsedArgs", (Object)DefaultGroovyMethods.join(args.params, (String)" "));
        binding.setVariable("scriptEnv", (Object)System.getProperty("griffon.env"));
        binding.setVariable("scriptName", (Object)this.scriptName);
        binding.setVariable("scriptFile", (Object)this.scriptFile);
        binding.setVariable("argsMap", argsMap);
        LinkedHashMap<String, String> sysProperties = new LinkedHashMap<String, String>();
        sysProperties.putAll(GriffonShellContext.getInitialSystemProperties());
        sysProperties.putAll(GriffonShellContext.getSystemProperties());
        binding.setVariable("sysProperties", sysProperties);
        Gant gant = runner.createGantInstance(binding);
        gant.loadScript(this.scriptFile);
        try {
            runner.executeWithGantInstance(gant, binding);
        }
        catch (ScriptExitException see) {
        }
        catch (RuntimeException e) {
            GriffonExceptionHandler.sanitize((Throwable)e);
            if (!(e instanceof ScriptExitException) && !(e.getCause() instanceof ScriptExitException)) {
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                e.printStackTrace(session.getConsole());
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
            }
        }
        finally {
            binding.setVariable("argsMap", this.emptyArgsMap());
            binding.setVariable("unparsedArgs", (Object)"");
        }
        return null;
    }

    private Map<String, Object> emptyArgsMap() {
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        argsMap.put("params", new ArrayList());
        return argsMap;
    }

    private void populateArguments(Map<String, Object> argsMap, List<Argument> orderedArguments, Object subject) throws CommandException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Argument arg : orderedArguments) {
            String argName = arg.name();
            try {
                Field field = subject.getClass().getDeclaredField(argName);
                field.setAccessible(true);
                Object value = field.get(subject);
                if (value == null) continue;
                arguments.add(value);
            }
            catch (IllegalAccessException e) {
                throw new CommandException("Could not read argument " + argName + " due to " + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new CommandException("Could not read argument " + argName + " due to " + e.getMessage());
            }
        }
        argsMap.put("params", DefaultGroovyMethods.flatten(arguments));
    }

    private void populateOptions(Map<String, Object> argsMap, Map<Option, Field> options, Object subject) throws CommandException {
        for (Map.Entry<Option, Field> option : options.entrySet()) {
            String optionName = option.getKey().name();
            if ("--env".equals(optionName) || "--non-interactive".equals(optionName)) continue;
            try {
                String val;
                Field field = option.getValue();
                field.setAccessible(true);
                Object value = field.get(subject);
                if (value == null || "false".equalsIgnoreCase(val = value.toString())) continue;
                if (optionName.startsWith("--")) {
                    optionName = optionName.substring(2);
                }
                if (optionName.startsWith("-")) {
                    optionName = optionName.substring(1);
                }
                argsMap.put(optionName, GriffonNameUtils.quote((String)val));
            }
            catch (IllegalAccessException e) {
                throw new CommandException("Could not read option " + optionName + " due to " + e.getMessage());
            }
        }
    }
}

