/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.params.HttpParams;

class OAuthScheme
implements AuthScheme {
    public static final String SCHEME_NAME = "OAuth";
    public static final String CONSUMER_KEY = "oauth.consumerKey";
    public static final String CONSUMER_SECRET = "oauth.consumerSecret";
    public static final String ACCESS_TOKEN = "oauth.accessToken";
    public static final String SECRET_TOKEN = "oauth.secretToken";
    protected OAuthConsumer oauth;
    private Map<String, String> params = new HashMap<String, String>();
    private boolean complete = false;

    public OAuthScheme(HttpParams params) {
        this.oauth = new CommonsHttpOAuthConsumer(params.getParameter(CONSUMER_KEY).toString(), params.getParameter(CONSUMER_SECRET).toString());
        this.oauth.setTokenWithSecret(params.getParameter(ACCESS_TOKEN).toString(), params.getParameter(SECRET_TOKEN).toString());
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        try {
            this.oauth.sign((Object)request);
        }
        catch (OAuthException ex) {
            throw new AuthenticationException("Error signing OAuth", (Throwable)ex);
        }
        Header authHeader = request.getHeaders("Authorization")[0];
        request.removeHeader(authHeader);
        this.complete = true;
        return authHeader;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        HeaderElement[] headerElementArray = header.getElements();
        int n = headerElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderElement e = headerElementArray[n2];
            if (e.getName().endsWith("realm")) {
                this.params.put("realm", e.getValue());
            }
            ++n2;
        }
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public String getRealm() {
        return this.getParameter("realm");
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }
}

