/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.api;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.api.ApiConverter;

public class ApiDoc {
    private static Log log = LogFactory.getLog(ApiDoc.class);
    private static ApiDoc instance;
    private Map apiDocs = new LinkedHashMap();

    public static synchronized ApiDoc getInstance() {
        if (null == instance) {
            instance = new ApiDoc();
        }
        return instance;
    }

    public ApiDoc() {
        BufferedReader bufferedReader;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("conf/apidocs.txt")));
            this.addApiDoc(bufferedReader);
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to read conf/apidocs.txt");
            bl = true;
        }
        if (bl) {
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(ApiDoc.class.getResourceAsStream("/conf/apidocs.txt")));
                this.addApiDoc(bufferedReader);
            }
            catch (Exception exception) {
                log.warn((Object)"Unable to read conf/apidocs.txt from jar");
            }
        }
    }

    public void addApiDoc(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            ApiConverter apiConverter = null;
            try {
                apiConverter = (ApiConverter)Class.forName("org.radeox.macro.api." + string4 + "ApiConverter").newInstance();
            }
            catch (Exception exception) {
                log.warn((Object)("Unable to load converter: " + string4 + "ApiConverter"), (Throwable)exception);
            }
            apiConverter.setBaseUrl(string3);
            this.apiDocs.put(string2.toLowerCase(), apiConverter);
        }
    }

    public boolean contains(String string) {
        return this.apiDocs.containsKey(string);
    }

    public Writer expand(Writer writer, String string, String string2) throws IOException {
        if (this.apiDocs.containsKey(string2 = string2.toLowerCase())) {
            writer.write("<a href=\"");
            ((ApiConverter)this.apiDocs.get(string2)).appendUrl(writer, string);
            writer.write("\">");
            writer.write(string);
            writer.write("</a>");
        } else {
            log.warn((Object)(string2 + " not found"));
        }
        return writer;
    }

    public Writer appendTo(Writer writer) throws IOException {
        writer.write("{table}\n");
        writer.write("Binding|BaseUrl|Converter Name\n");
        for (Map.Entry entry : this.apiDocs.entrySet()) {
            writer.write((String)entry.getKey());
            ApiConverter apiConverter = (ApiConverter)entry.getValue();
            writer.write("|");
            writer.write(apiConverter.getBaseUrl());
            writer.write("|");
            writer.write(apiConverter.getName());
            writer.write("\n");
        }
        writer.write("{table}");
        return writer;
    }
}

