/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.LocaleMacro;
import org.radeox.macro.Preserved;
import org.radeox.util.i18n.ResourceManager;

public abstract class LocalePreserved
extends Preserved
implements LocaleMacro {
    private static Log log = LogFactory.getLog(LocalePreserved.class);
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        try {
            return ResourceManager.getBundle((String)this.initialContext.get("RenderContext.language_bundle_name")).getString(this.getLocaleKey() + ".description");
        }
        catch (Exception exception) {
            log.warn((Object)("missing macro description for " + this.getLocaleKey()));
            return super.getDescription();
        }
    }

    @Override
    public String[] getParamDescription() {
        try {
            return ResourceManager.getBundle((String)this.initialContext.get("RenderContext.language_bundle_name")).getString(this.getLocaleKey() + ".params").split(";");
        }
        catch (Exception exception) {
            return super.getParamDescription();
        }
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        Locale locale = (Locale)initialRenderContext.get("RenderContext.language_locale");
        String string = (String)initialRenderContext.get("RenderContext.language_bundle_name");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        Locale locale2 = (Locale)initialRenderContext.get("RenderContext.input_locale");
        String string2 = (String)initialRenderContext.get("RenderContext.input_bundle_name");
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string2, locale2);
        this.name = resourceBundle2.getString(this.getLocaleKey() + ".name");
        try {
            this.description = resourceBundle.getString(this.getLocaleKey() + ".description");
        }
        catch (Exception exception) {
            log.warn((Object)("Cannot read description from properties " + string2 + " for " + this.getLocaleKey()));
        }
    }
}

