/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.List;
import javafx.scene.paint.Color;
import jfxtras.labs.scene.control.gauge.ColorDef;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.Lcd;
import jfxtras.labs.scene.control.gauge.LcdDesign;
import jfxtras.labs.scene.control.gauge.LedColor;
import jfxtras.labs.scene.control.gauge.Linear;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Radial;
import jfxtras.labs.scene.control.gauge.RadialHalfN;
import jfxtras.labs.scene.control.gauge.RadialHalfS;
import jfxtras.labs.scene.control.gauge.RadialQuarterE;
import jfxtras.labs.scene.control.gauge.RadialQuarterN;
import jfxtras.labs.scene.control.gauge.RadialQuarterS;
import jfxtras.labs.scene.control.gauge.RadialQuarterW;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.StyleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeBuilder<T extends Gauge> {
    private GaugeType gaugeType;
    private GaugeModel gaugeModel;
    private StyleModel styleModel;

    public final GaugeBuilder create(GaugeType GAUGE_TYPE) {
        this.gaugeType = GAUGE_TYPE;
        this.gaugeModel = new GaugeModel();
        this.styleModel = new StyleModel();
        return this;
    }

    public final Gauge build() {
        switch (this.gaugeType) {
            case LCD: {
                return new Lcd(this.gaugeModel, this.styleModel);
            }
            case LINEAR: {
                return new Linear(this.gaugeModel, this.styleModel);
            }
            case RADIAL_HALF_N: {
                return new RadialHalfN(this.gaugeModel, this.styleModel);
            }
            case RADIAL_HALF_S: {
                return new RadialHalfS(this.gaugeModel, this.styleModel);
            }
            case RADIAL_QUARTER_N: {
                return new RadialQuarterN(this.gaugeModel, this.styleModel);
            }
            case RADIAL_QUARTER_E: {
                return new RadialQuarterE(this.gaugeModel, this.styleModel);
            }
            case RADIAL_QUARTER_S: {
                return new RadialQuarterS(this.gaugeModel, this.styleModel);
            }
            case RADIAL_QUARTER_W: {
                return new RadialQuarterW(this.gaugeModel, this.styleModel);
            }
        }
        return new Radial(this.gaugeModel, this.styleModel);
    }

    public final GaugeBuilder value(double VALUE) {
        this.gaugeModel.setValue(VALUE);
        return this;
    }

    public final GaugeBuilder valueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.gaugeModel.setValueAnimationEnabled(VALUE_ANIMATION_ENABLED);
        return this;
    }

    public final GaugeBuilder animationDuration(double ANIMATION_DURATION) {
        this.gaugeModel.setAnimationDuration(ANIMATION_DURATION);
        return this;
    }

    public final GaugeBuilder minValue(double MIN_VALUE) {
        this.gaugeModel.setMinValue(MIN_VALUE);
        return this;
    }

    public final GaugeBuilder maxValue(double MAX_VALUE) {
        this.gaugeModel.setMaxValue(MAX_VALUE);
        return this;
    }

    public final GaugeBuilder threshold(double THRESHOLD) {
        this.gaugeModel.setThreshold(THRESHOLD);
        return this;
    }

    public final GaugeBuilder thresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setThresholdBehaviorInverted(THRESHOLD_BEHAVIOR_INVERTED);
        return this;
    }

    public final GaugeBuilder title(String TITLE) {
        this.gaugeModel.setTitle(TITLE);
        return this;
    }

    public final GaugeBuilder unit(String UNIT) {
        this.gaugeModel.setUnit(UNIT);
        return this;
    }

    public final GaugeBuilder lcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.gaugeModel.setLcdValueCoupled(LCD_VALUE_COUPLED);
        return this;
    }

    public final GaugeBuilder lcdThreshold(double LCD_THRESHOLD) {
        this.gaugeModel.setLcdThreshold(LCD_THRESHOLD);
        return this;
    }

    public final GaugeBuilder lcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setLcdThresholdBehaviorInverted(LCD_THRESHOLD_BEHAVIOR_INVERTED);
        return this;
    }

    public final GaugeBuilder lcdUnitString(String LCD_UNIT_STRING) {
        this.gaugeModel.setLcdUnit(LCD_UNIT_STRING);
        return this;
    }

    public final GaugeBuilder lcdNumberSystem(Gauge.NumberSystem LCD_NUMBER_SYSTEM) {
        this.gaugeModel.setLcdNumberSystem(LCD_NUMBER_SYSTEM);
        return this;
    }

    public final GaugeBuilder maxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.gaugeModel.setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
        return this;
    }

    public final GaugeBuilder maxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.gaugeModel.setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
        return this;
    }

    public final GaugeBuilder majorTickSpacing(int MAJOR_TICKSPACING) {
        this.gaugeModel.setMajorTickSpacing(MAJOR_TICKSPACING);
        return this;
    }

    public final GaugeBuilder minorTickSpacing(int MINOR_TICKSPACING) {
        this.gaugeModel.setMinorTickSpacing(MINOR_TICKSPACING);
        return this;
    }

    public final GaugeBuilder trend(Gauge.Trend TREND) {
        this.gaugeModel.setTrend(TREND);
        return this;
    }

    public final GaugeBuilder niceScaling(boolean NICE_SCALING) {
        this.gaugeModel.setNiceScaling(NICE_SCALING);
        return this;
    }

    public final GaugeBuilder sections(Section ... SECTION_ARRAY) {
        this.gaugeModel.setSections(SECTION_ARRAY);
        return this;
    }

    public final GaugeBuilder sections(List<Section> SECTIONS) {
        this.gaugeModel.setSections(SECTIONS);
        return this;
    }

    public final GaugeBuilder areas(Section ... AREAS_ARRAY) {
        this.gaugeModel.setAreas(AREAS_ARRAY);
        return this;
    }

    public final GaugeBuilder areas(List<Section> AREAS) {
        this.gaugeModel.setAreas(AREAS);
        return this;
    }

    public final GaugeBuilder markers(Marker ... MARKER_ARRAY) {
        this.gaugeModel.setMarkers(MARKER_ARRAY);
        return this;
    }

    public final GaugeBuilder markers(List<Marker> MARKERS) {
        this.gaugeModel.setMarkers(MARKERS);
        return this;
    }

    public final GaugeBuilder bargraph(boolean BARGRAPH) {
        this.styleModel.setBargraph(BARGRAPH);
        return this;
    }

    public final GaugeBuilder minMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMinMeasuredValueVisible(MIN_MEASURED_VALUE_VISIBLE);
        return this;
    }

    public final GaugeBuilder maxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMaxMeasuredValueVisible(MAX_MEASURED_VALUE_VISIBLE);
        return this;
    }

    public final GaugeBuilder thresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.styleModel.setThresholdVisible(THRESHOLD_VISIBLE);
        return this;
    }

    public final GaugeBuilder thresholdColor(Gauge.ThresholdColor THRESHOLD_COLOR) {
        this.styleModel.setThresholdColor(THRESHOLD_COLOR);
        return this;
    }

    public final GaugeBuilder frameDesign(Gauge.FrameDesign FRAME_DESIGN) {
        this.styleModel.setFrameDesign(FRAME_DESIGN);
        return this;
    }

    public final GaugeBuilder frameVisible(boolean FRAME_VISIBLE) {
        this.styleModel.setFrameVisible(FRAME_VISIBLE);
        return this;
    }

    public final GaugeBuilder backgroundDesign(Gauge.BackgroundDesign BACKGROUND_DESIGN) {
        this.styleModel.setBackgroundDesign(BACKGROUND_DESIGN);
        return this;
    }

    public final GaugeBuilder backgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.styleModel.setBackgroundVisible(BACKGROUND_VISIBLE);
        return this;
    }

    public final GaugeBuilder knobDesign(Gauge.KnobDesign KNOB_DESIGN) {
        this.styleModel.setKnobDesign(KNOB_DESIGN);
        return this;
    }

    public final GaugeBuilder knobColor(Gauge.KnobColor KNOB_COLOR) {
        this.styleModel.setKnobColor(KNOB_COLOR);
        return this;
    }

    public final GaugeBuilder postsVisible(boolean POSTS_VISIBLE) {
        this.styleModel.setPostsVisible(POSTS_VISIBLE);
        return this;
    }

    public final GaugeBuilder pointerType(Gauge.PointerType POINTER_TYPE) {
        this.styleModel.setPointerType(POINTER_TYPE);
        return this;
    }

    public final GaugeBuilder valueColor(ColorDef VALUE_COLOR) {
        this.styleModel.setValueColor(VALUE_COLOR);
        return this;
    }

    public final GaugeBuilder pointerGlowEnabled(boolean POINTER_GLOW_ENABLED) {
        this.styleModel.setPointerGlowEnabled(POINTER_GLOW_ENABLED);
        return this;
    }

    public final GaugeBuilder pointerShadowEnabled(boolean POINTER_SHADOW_ENABLED) {
        this.styleModel.setPointerShadowEnabled(POINTER_SHADOW_ENABLED);
        return this;
    }

    public final GaugeBuilder ledVisible(boolean LED_VISIBLE) {
        this.styleModel.setLedVisible(LED_VISIBLE);
        return this;
    }

    public final GaugeBuilder ledColor(LedColor LED_COLOR) {
        this.styleModel.setLedColor(LED_COLOR);
        return this;
    }

    public final GaugeBuilder userLedVisible(boolean USER_LED_VISIBLE) {
        this.styleModel.setUserLedVisible(USER_LED_VISIBLE);
        return this;
    }

    public final GaugeBuilder userLedColor(LedColor USER_LED_COLOR) {
        this.styleModel.setUserLedColor(USER_LED_COLOR);
        return this;
    }

    public final GaugeBuilder userLedOn(boolean USER_LED_ON) {
        this.styleModel.setUserLedOn(USER_LED_ON);
        return this;
    }

    public final GaugeBuilder userLedBlinking(boolean USER_LED_BLINKING) {
        this.styleModel.setUserLedBlinking(USER_LED_BLINKING);
        return this;
    }

    public final GaugeBuilder foregroundType(Radial.ForegroundType FOREGROUND_TYPE) {
        this.styleModel.setForegroundType(FOREGROUND_TYPE);
        return this;
    }

    public final GaugeBuilder foregroundVisible(boolean FOREGROUND_VISIBLE) {
        this.styleModel.setForegroundVisible(FOREGROUND_VISIBLE);
        return this;
    }

    public final GaugeBuilder lcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.styleModel.setLcdThresholdVisible(LCD_THRESHOLD_VISIBLE);
        return this;
    }

    public final GaugeBuilder lcdDesign(LcdDesign LCD_Design) {
        this.styleModel.setLcdDesign(LCD_Design);
        return this;
    }

    public final GaugeBuilder lcdVisible(boolean LCD_VISIBLE) {
        this.styleModel.setLcdVisible(LCD_VISIBLE);
        return this;
    }

    public final GaugeBuilder lcdUnitStringVisible(boolean LCD_UNIT_STRING_VISIBLE) {
        this.styleModel.setLcdUnitVisible(LCD_UNIT_STRING_VISIBLE);
        return this;
    }

    public final GaugeBuilder lcdDigitalFontEnabled(boolean LCD_DIGITAL_FONT_ENABLED) {
        this.styleModel.setLcdDigitalFontEnabled(LCD_DIGITAL_FONT_ENABLED);
        return this;
    }

    public final GaugeBuilder lcdNumberSystemVisible(boolean NUMBER_SYSTEM_VISIBLE) {
        this.styleModel.setLcdNumberSystemVisible(NUMBER_SYSTEM_VISIBLE);
        return this;
    }

    public final GaugeBuilder lcdUnitFont(String UNIT_FONT) {
        this.styleModel.setLcdUnitFont(UNIT_FONT);
        return this;
    }

    public final GaugeBuilder lcdDecimals(int LCD_DECIMALS) {
        this.styleModel.setLcdDecimals(LCD_DECIMALS);
        return this;
    }

    public final GaugeBuilder lcdBlinking(boolean LCD_BLINKING) {
        this.styleModel.setLcdBlinking(LCD_BLINKING);
        return this;
    }

    public final GaugeBuilder glowVisible(boolean GLOW_VISIBLE) {
        this.styleModel.setGlowVisible(GLOW_VISIBLE);
        return this;
    }

    public final GaugeBuilder glowOn(boolean GLOW_ON) {
        this.styleModel.setGlowOn(GLOW_ON);
        return this;
    }

    public final GaugeBuilder pulsatingGlow(boolean PULSATING_GLOW) {
        this.styleModel.setPulsatingGlow(PULSATING_GLOW);
        return this;
    }

    public final GaugeBuilder glowColor(Color GLOW_COLOR) {
        this.styleModel.setGlowColor(GLOW_COLOR);
        return this;
    }

    public final GaugeBuilder tickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.styleModel.setTickmarksVisible(TICKMARKS_VISIBLE);
        return this;
    }

    public final GaugeBuilder majorTickmarksVisible(boolean MAJOR_TICKMARKS_VISIBLE) {
        this.styleModel.setMajorTicksVisible(MAJOR_TICKMARKS_VISIBLE);
        return this;
    }

    public final GaugeBuilder majorTickmarkType(Gauge.TickmarkType TICKMARK_TYPE) {
        this.styleModel.setMajorTickmarkType(TICKMARK_TYPE);
        return this;
    }

    public final GaugeBuilder minorTickmarksVisible(boolean MINOR_TICKMARKS_VISIBLE) {
        this.styleModel.setMinorTicksVisible(MINOR_TICKMARKS_VISIBLE);
        return this;
    }

    public final GaugeBuilder tickLabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.styleModel.setTickLabelsVisible(TICKLABELS_VISIBLE);
        return this;
    }

    public final GaugeBuilder tickLabelOrientation(Gauge.TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.styleModel.setTickLabelOrientation(TICKLABEL_ORIENTATION);
        return this;
    }

    public final GaugeBuilder tickLabelNumberFormat(Gauge.NumberFormat TICKLABEL_NUMBER_FORMAT) {
        this.styleModel.setTickLabelNumberFormat(TICKLABEL_NUMBER_FORMAT);
        return this;
    }

    public final GaugeBuilder tickmarkGlowEnabled(boolean TICKMARK_GLOW_ENABLED) {
        this.styleModel.setTickmarkGlowEnabled(TICKMARK_GLOW_ENABLED);
        return this;
    }

    public final GaugeBuilder tickmarkGlowColor(Color TICKMARK_GLOW_COLOR) {
        this.styleModel.setTickmarkGlowColor(TICKMARK_GLOW_COLOR);
        return this;
    }

    public final GaugeBuilder sectionsVisible(boolean SECTIONS_VISIBLE) {
        this.styleModel.setSectionsVisible(SECTIONS_VISIBLE);
        return this;
    }

    public final GaugeBuilder sectionsHighlighting(boolean SECTIONS_HIGHLIGHTING) {
        this.styleModel.setSectionsHighlighting(SECTIONS_HIGHLIGHTING);
        return this;
    }

    public final GaugeBuilder areasVisible(boolean AREAS_VISIBLE) {
        this.styleModel.setAreasVisible(AREAS_VISIBLE);
        return this;
    }

    public final GaugeBuilder areasHighlighting(boolean AREAS_HIGHLIGHTING) {
        this.styleModel.setAreasHighlighting(AREAS_HIGHLIGHTING);
        return this;
    }

    public final GaugeBuilder markersVisible(boolean MARKERS_VISIBLE) {
        this.styleModel.setMarkersVisible(MARKERS_VISIBLE);
        return this;
    }

    public final GaugeBuilder textureColor(Color TEXTURE_COLOR) {
        this.styleModel.setTextureColor(TEXTURE_COLOR);
        return this;
    }

    public final GaugeBuilder simpleGradientBaseColor(Color SIMPLE_GRADIENT_BASE_COLOR) {
        this.styleModel.setSimpleGradientBaseColor(SIMPLE_GRADIENT_BASE_COLOR);
        return this;
    }

    public final GaugeBuilder titleVisible(boolean TITLE_VISIBLE) {
        this.styleModel.setTitleVisible(TITLE_VISIBLE);
        return this;
    }

    public final GaugeBuilder unitVisible(boolean UNIT_VISIBLE) {
        this.styleModel.setUnitVisible(UNIT_VISIBLE);
        return this;
    }

    public final GaugeBuilder trendVisible(boolean TREND_VISIBLE) {
        this.styleModel.setTrendVisible(TREND_VISIBLE);
        return this;
    }

    public final GaugeBuilder trendUpColor(Color TREND_UP_COLOR) {
        this.styleModel.setTrendUpColor(TREND_UP_COLOR);
        return this;
    }

    public final GaugeBuilder trendSteadyColor(Color TREND_STEADY_COLOR) {
        this.styleModel.setTrendSteadyColor(TREND_STEADY_COLOR);
        return this;
    }

    public final GaugeBuilder trendDownColor(Color TREND_DOWN_COLOR) {
        this.styleModel.setTrendDownColor(TREND_DOWN_COLOR);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GaugeType {
        LCD,
        LINEAR,
        RADIAL_HALF_N,
        RADIAL_HALF_S,
        RADIAL_QUARTER_N,
        RADIAL_QUARTER_E,
        RADIAL_QUARTER_S,
        RADIAL_QUARTER_W,
        RADIAL;

    }
}

