/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.Calendar;
import java.util.Date;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;

public class Clock
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "clock";
    private StringProperty timeZone = new SimpleStringProperty(Calendar.getInstance().getTimeZone().getDisplayName());
    private BooleanProperty running = new SimpleBooleanProperty(false);
    private BooleanProperty secondPointerVisible = new SimpleBooleanProperty(true);
    private BooleanProperty autoDimEnabled = new SimpleBooleanProperty(true);
    private BooleanProperty daylightSavingTime = new SimpleBooleanProperty(Calendar.getInstance().getTimeZone().inDaylightTime(new Date()));

    public Clock() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    public final String getTimeZone() {
        return (String)this.timeZone.get();
    }

    public final void setTimeZone(String TIME_ZONE) {
        this.timeZone.set((Object)TIME_ZONE);
    }

    public final StringProperty timeZoneProperty() {
        return this.timeZone;
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    public final void setRunning(boolean RUNNING) {
        this.running.set(RUNNING);
    }

    public final BooleanProperty runningProperty() {
        return this.running;
    }

    public final boolean isSecondPointerVisible() {
        return this.secondPointerVisible.get();
    }

    public final void setSecondPointerVisible(boolean SECOND_POINTER_VISIBLE) {
        this.secondPointerVisible.set(SECOND_POINTER_VISIBLE);
    }

    public final BooleanProperty secondPointerVisibleProperty() {
        return this.secondPointerVisible;
    }

    public final boolean isAutoDimEnabled() {
        return this.autoDimEnabled.get();
    }

    public final void setAutoDimEnabled(boolean AUTO_DIM_ENABLED) {
        this.autoDimEnabled.set(AUTO_DIM_ENABLED);
    }

    public final BooleanProperty autoDimEnabledProperty() {
        return this.autoDimEnabled;
    }

    public final boolean isDaylightSavingTime() {
        return this.daylightSavingTime.get();
    }

    public final void setDaylightSavingTime(boolean DAYLIGHT_SAVING_TIME) {
        this.daylightSavingTime.set(DAYLIGHT_SAVING_TIME);
    }

    public final BooleanProperty daylightSavingTimeProperty() {
        return this.daylightSavingTime;
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }
}

