/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.SimpleIndicatorBehavior;
import jfxtras.labs.scene.control.gauge.SimpleIndicator;
import jfxtras.labs.scene.control.gauge.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndicatorSkin
extends SkinBase<SimpleIndicator, SimpleIndicatorBehavior> {
    private SimpleIndicator control;
    private boolean isDirty;
    private boolean initialized;
    private Group indicator;
    private Circle main;
    private DropShadow mainGlow;

    public SimpleIndicatorSkin(SimpleIndicator CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SimpleIndicatorBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.indicator = new Group();
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(48.0, 48.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SimpleIndicatorSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SimpleIndicatorSkin.this.isDirty = true;
            }
        });
        this.registerChangeListener((ObservableValue)this.control.innerColorProperty(), "INNER_COLOR");
        this.registerChangeListener((ObservableValue)this.control.outerColorProperty(), "OUTER_COLOR");
        this.registerChangeListener((ObservableValue)this.control.glowVisibleProperty(), "GLOW_VISIBILITY");
        this.initialized = true;
        this.paint();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawIndicator();
        this.getChildren().addAll((Object[])new Node[]{this.indicator});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "INNER_COLOR") {
            this.updateIndicator();
        } else if (PROPERTY == "OUTER_COLOR") {
            this.updateIndicator();
        } else if (PROPERTY == "GLOW_VISIBILITY") {
            this.paint();
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final SimpleIndicator getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 250.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 250.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void updateIndicator() {
        this.main.setStyle("-fx-indicator-inner-color: " + Util.INSTANCE.createCssColor(this.control.getInnerColor()) + "-fx-indicator-outer-color: " + Util.INSTANCE.createCssColor(this.control.getOuterColor()));
        this.main.setId("indicator-main-fill");
        this.mainGlow.setColor(this.control.getInnerColor());
    }

    private final void drawIndicator() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.indicator.setStyle("-fx-indicator-inner-color: " + Util.INSTANCE.createCssColor(this.control.getInnerColor()) + "-fx-indicator-outer-color: " + Util.INSTANCE.createCssColor(this.control.getOuterColor()));
        this.indicator.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.indicator.getChildren().add((Object)IBOUNDS);
        Circle OUTER_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.496 * WIDTH);
        OUTER_FRAME.setId("indicator-outer-frame-fill");
        OUTER_FRAME.setStroke(null);
        InnerShadow OUTER_FRAME_INNER_SHADOW = new InnerShadow();
        OUTER_FRAME_INNER_SHADOW.setWidth(0.05 * OUTER_FRAME.getLayoutBounds().getWidth());
        OUTER_FRAME_INNER_SHADOW.setHeight(0.05 * OUTER_FRAME.getLayoutBounds().getHeight());
        OUTER_FRAME_INNER_SHADOW.setOffsetX(0.0);
        OUTER_FRAME_INNER_SHADOW.setOffsetY(0.0);
        OUTER_FRAME_INNER_SHADOW.setRadius(0.05 * OUTER_FRAME.getLayoutBounds().getWidth());
        OUTER_FRAME_INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.9));
        OUTER_FRAME_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        OUTER_FRAME_INNER_SHADOW.inputProperty().set(null);
        OUTER_FRAME.setEffect((Effect)OUTER_FRAME_INNER_SHADOW);
        Circle INNER_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4 * WIDTH);
        INNER_FRAME.setId("indicator-inner-frame-fill");
        INNER_FRAME.setStroke(null);
        this.main = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.38 * WIDTH);
        this.main.setId("indicator-main-fill");
        this.main.setStroke(null);
        InnerShadow MAIN_INNER_SHADOW = new InnerShadow();
        MAIN_INNER_SHADOW.setWidth(0.288 * this.main.getLayoutBounds().getWidth());
        MAIN_INNER_SHADOW.setHeight(0.288 * this.main.getLayoutBounds().getHeight());
        MAIN_INNER_SHADOW.setOffsetX(0.0);
        MAIN_INNER_SHADOW.setOffsetY(0.0);
        MAIN_INNER_SHADOW.setRadius(0.288 * this.main.getLayoutBounds().getWidth());
        MAIN_INNER_SHADOW.setColor(Color.BLACK);
        MAIN_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        this.mainGlow = new DropShadow();
        this.mainGlow.setWidth(0.288 * this.main.getLayoutBounds().getWidth());
        this.mainGlow.setHeight(0.288 * this.main.getLayoutBounds().getHeight());
        this.mainGlow.setOffsetX(0.0);
        this.mainGlow.setOffsetY(0.0);
        this.mainGlow.setRadius(0.288 * this.main.getLayoutBounds().getWidth());
        this.mainGlow.setColor(this.control.getInnerColor());
        this.mainGlow.setBlurType(BlurType.GAUSSIAN);
        this.mainGlow.inputProperty().set((Object)MAIN_INNER_SHADOW);
        if (this.control.isGlowVisible()) {
            this.main.setEffect((Effect)this.mainGlow);
        } else {
            this.main.setEffect((Effect)MAIN_INNER_SHADOW);
        }
        Ellipse HIGHLIGHT = new Ellipse(0.504 * WIDTH, 0.294 * HEIGHT, 0.26 * WIDTH, 0.15 * HEIGHT);
        HIGHLIGHT.setId("indicator-highlight-fill");
        HIGHLIGHT.setStroke(null);
        this.indicator.getChildren().addAll((Object[])new Node[]{OUTER_FRAME, INNER_FRAME, this.main, HIGHLIGHT});
        this.indicator.setCache(true);
    }
}

