/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell;

import gant.Gant;
import griffon.util.GriffonExceptionHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.service.command.CommandSession;
import org.codehaus.gant.GantBinding;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.ScriptExitException;
import org.codehaus.griffon.cli.shell.AbstractGriffonShellCommand;
import org.codehaus.griffon.cli.shell.Argument;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.codehaus.griffon.cli.shell.Option;
import org.codehaus.griffon.cli.shell.support.CommandArguments;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.fusesource.jansi.Ansi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GantAwareAction
extends AbstractGriffonShellCommand {
    private final String scope;
    private final String name;
    private final File scriptFile;
    private final String scriptName;

    public GantAwareAction(String scope, String name, File scriptFile) {
        this.scope = scope;
        this.name = name;
        this.scriptFile = scriptFile;
        this.scriptName = GriffonScriptRunner.getScriptNameFromFile((File)scriptFile);
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute(CommandSession session, CommandArguments args) throws Exception {
        GriffonScriptRunner runner = GriffonShellContext.getGriffonScriptRunner();
        GantBinding binding = GriffonShellContext.getGantBinding();
        binding = new GantBinding();
        GriffonShellContext.setGantBinding(binding);
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        ArrayList arguments = new ArrayList();
        this.populateOptions(argsMap, args.options, args.subject);
        this.populateArguments(argsMap, args.orderedArguments, args.subject);
        binding.setVariable("scriptEnv", (Object)System.getProperty("griffon.env"));
        binding.setVariable("scriptName", (Object)this.scriptName);
        binding.setVariable("scriptFile", (Object)this.scriptFile);
        binding.setVariable("argsMap", argsMap);
        Gant gant = runner.createGantInstance(binding);
        gant.loadScript(this.scriptFile);
        try {
            runner.executeWithGantInstance(gant, binding);
        }
        catch (ScriptExitException see) {
        }
        catch (RuntimeException e) {
            GriffonExceptionHandler.sanitize((Throwable)e);
            if (!(e instanceof ScriptExitException) && !(e.getCause() instanceof ScriptExitException)) {
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                e.printStackTrace(session.getConsole());
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
            }
        }
        finally {
            binding.setVariable("argsMap", this.emptyArgsMap());
        }
        return null;
    }

    private Map<String, Object> emptyArgsMap() {
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        argsMap.put("params", new ArrayList());
        return argsMap;
    }

    private void populateArguments(Map<String, Object> argsMap, List<Argument> orderedArguments, Object subject) throws CommandException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Argument arg : orderedArguments) {
            String argName = arg.name();
            try {
                Field field = subject.getClass().getDeclaredField(argName);
                field.setAccessible(true);
                Object value = field.get(subject);
                if (value == null) continue;
                arguments.add(value);
            }
            catch (IllegalAccessException e) {
                throw new CommandException("Could not read argument " + argName + " due to " + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new CommandException("Could not read argument " + argName + " due to " + e.getMessage());
            }
        }
        argsMap.put("params", DefaultGroovyMethods.flatten(arguments));
    }

    private void populateOptions(Map<String, Object> argsMap, Map<Option, Field> options, Object subject) throws CommandException {
        for (Map.Entry<Option, Field> option : options.entrySet()) {
            String optionName = option.getKey().name();
            if ("--env".equals(optionName) || "--non-interactive".equals(optionName)) continue;
            try {
                String val;
                Field field = option.getValue();
                field.setAccessible(true);
                Object value = field.get(subject);
                if (value == null || "false".equalsIgnoreCase(val = value.toString())) continue;
                argsMap.put(optionName, this.quote(val));
            }
            catch (IllegalAccessException e) {
                throw new CommandException("Could not read option " + optionName + " due to " + e.getMessage());
            }
        }
    }

    private String quote(Object value) {
        String val = value.toString();
        if (val.contains(" ")) {
            val = this.applyQuotes(val);
        }
        return val;
    }

    private String applyQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len * 2);
        char[] chars = string.toCharArray();
        char[] buffer = new char[1030];
        int bufferIndex = 0;
        sb.append('\"');
        block11: for (int i = 0; i < len; ++i) {
            if (bufferIndex > 1024) {
                sb.append(buffer, 0, bufferIndex);
                bufferIndex = 0;
            }
            char b = c;
            c = chars[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    buffer[bufferIndex++] = 92;
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                case '/': {
                    if (b == '<') {
                        buffer[bufferIndex++] = 92;
                    }
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\b': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 114;
                                continue block11;
                            }
                        }
                        String t = "000" + Integer.toHexString(c);
                        int tLength = t.length();
                        buffer[bufferIndex++] = 92;
                        buffer[bufferIndex++] = 117;
                        buffer[bufferIndex++] = t.charAt(tLength - 4);
                        buffer[bufferIndex++] = t.charAt(tLength - 3);
                        buffer[bufferIndex++] = t.charAt(tLength - 2);
                        buffer[bufferIndex++] = t.charAt(tLength - 1);
                        continue block11;
                    }
                    buffer[bufferIndex++] = c;
                }
            }
        }
        sb.append(buffer, 0, bufferIndex);
        sb.append('\"');
        return sb.toString();
    }
}

