/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ArtifactInfo;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.GriffonService;
import griffon.core.ServiceManager;
import griffon.util.ConfigUtils;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.griffon.runtime.core.AbstractServiceManager;
import org.codehaus.griffon.runtime.core.ArtifactHandlerAdapter;
import org.codehaus.griffon.runtime.core.DefaultGriffonServiceClass;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceArtifactHandler
extends ArtifactHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceArtifactHandler.class);
    private final ServiceManager serviceManager;

    public ServiceArtifactHandler(GriffonApplication app) {
        super(app, "service", "Service");
        this.serviceManager = new DefaultServiceManager(app);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering " + this.serviceManager + " as ServiceManager.");
        }
        InvokerHelper.setProperty((Object)app, (String)"serviceManager", (Object)this.serviceManager);
    }

    protected GriffonClass newGriffonClassInstance(Class clazz) {
        return new DefaultGriffonServiceClass(this.getApp(), clazz);
    }

    public void initialize(ArtifactInfo[] artifacts) {
        super.initialize(artifacts);
        if (this.isBasicInjectionDisabled()) {
            return;
        }
        if (this.isEagerInstantiationEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Instantiating service instances eagerly");
            }
            for (ArtifactInfo artifactInfo : artifacts) {
                GriffonClass griffonClass = this.getClassFor(artifactInfo.getClazz());
                this.serviceManager.findService(griffonClass.getPropertyName());
            }
        }
        this.getApp().addApplicationEventListener(this);
    }

    public void onNewInstance(Class klass, String t, Object instance) {
        if (this.isBasicInjectionDisabled()) {
            return;
        }
        MetaClass metaClass = InvokerHelper.getMetaClass((Object)instance);
        for (MetaProperty property : metaClass.getProperties()) {
            GriffonService serviceInstance;
            String propertyName = property.getName();
            if (!propertyName.endsWith(this.getTrailing()) || (serviceInstance = this.serviceManager.findService(propertyName)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting service " + serviceInstance + " on " + instance + " using property '" + propertyName + "'");
            }
            InvokerHelper.setProperty((Object)instance, (String)propertyName, (Object)serviceInstance);
        }
    }

    private boolean isBasicInjectionDisabled() {
        return ConfigUtils.getConfigValueAsBoolean((Map)this.getApp().getConfig(), "griffon.basic_injection.disable", false);
    }

    private boolean isEagerInstantiationEnabled() {
        return ConfigUtils.getConfigValueAsBoolean((Map)this.getApp().getConfig(), "griffon.services.eager.instantiation", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultServiceManager
    extends AbstractServiceManager {
        private final Map<String, GriffonService> serviceInstances;

        public DefaultServiceManager(GriffonApplication app) {
            super(app);
            this.serviceInstances = new ConcurrentHashMap<String, GriffonService>();
        }

        @Override
        public Map<String, GriffonService> getServices() {
            return Collections.unmodifiableMap(this.serviceInstances);
        }

        @Override
        public GriffonService findService(String name) {
            GriffonClass griffonClass;
            GriffonService serviceInstance = this.serviceInstances.get(name);
            if (serviceInstance == null && (griffonClass = ServiceArtifactHandler.this.findClassFor(name)) != null) {
                serviceInstance = this.instantiateService(griffonClass);
                this.serviceInstances.put(name, serviceInstance);
            }
            return serviceInstance;
        }

        private GriffonService instantiateService(GriffonClass griffonClass) {
            GriffonService serviceInstance = (GriffonService)griffonClass.newInstance();
            InvokerHelper.setProperty((Object)serviceInstance, (String)"app", (Object)this.getApp());
            this.getApp().addApplicationEventListener(serviceInstance);
            return serviceInstance;
        }
    }
}

