/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonArtifact;
import griffon.core.UIThreadManager;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRouter {
    private boolean enabled = true;
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final Map<Script, Binding> scriptBindings = new LinkedHashMap<Script, Binding>();
    private final Map<String, List> closureListeners = Collections.synchronizedMap(new LinkedHashMap());
    private final BlockingQueue<Runnable> deferredEvents = new LinkedBlockingQueue<Runnable>();
    private static final Logger LOG = LoggerFactory.getLogger(EventRouter.class);
    private static final Object LOCK = new Object();
    private static int count = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int identifier() {
        Object object = LOCK;
        synchronized (object) {
            return count++;
        }
    }

    public EventRouter() {
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ((Runnable)EventRouter.this.deferredEvents.take()).run();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }, "EventRouter-" + EventRouter.identifier()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = LOCK;
        synchronized (object) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Object object = LOCK;
        synchronized (object) {
            this.enabled = enabled;
        }
    }

    public void publish(String eventName) {
        this.publish(eventName, Collections.EMPTY_LIST);
    }

    public void publish(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        this.buildPublisher(eventName, params, "synchronously").run();
    }

    @Deprecated
    public void publishOutside(String eventName) {
        this.publishOutside(eventName, Collections.EMPTY_LIST);
    }

    @Deprecated
    public void publishOutside(String eventName, List params) {
        this.publishOutsideUI(eventName, params);
    }

    public void publishOutsideUI(String eventName) {
        this.publishOutsideUI(eventName, Collections.EMPTY_LIST);
    }

    public void publishOutsideUI(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        UIThreadManager.getInstance().executeOutside(this.buildPublisher(eventName, params, "outside UI"));
    }

    public void publishAsync(String eventName) {
        this.publishAsync(eventName, Collections.EMPTY_LIST);
    }

    public void publishAsync(String eventName, List params) {
        if (!this.isEnabled()) {
            return;
        }
        if (GriffonNameUtils.isBlank(eventName)) {
            return;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        this.deferredEvents.offer(this.buildPublisher(eventName, params, "asynchronously"));
    }

    private Runnable buildPublisher(final String event, final List params, final String mode) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String eventName = GriffonNameUtils.capitalize(event);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Triggering event '" + eventName + "' " + mode);
                }
                String eventHandler = "on" + eventName;
                ArrayList listenersCopy = new ArrayList();
                Object object = EventRouter.this.listeners;
                synchronized (object) {
                    listenersCopy.addAll(EventRouter.this.listeners);
                }
                object = EventRouter.this.closureListeners;
                synchronized (object) {
                    List list = (List)EventRouter.this.closureListeners.get(eventName);
                    if (list != null) {
                        for (Object listener : list) {
                            listenersCopy.add(listener);
                        }
                    }
                }
                for (Object listener : listenersCopy) {
                    if (listener instanceof Script) {
                        EventRouter.this.fireEvent((Script)listener, eventHandler, params);
                        continue;
                    }
                    if (listener instanceof Closure) {
                        EventRouter.this.fireEvent((Closure)listener, eventHandler, params);
                        continue;
                    }
                    if (listener instanceof RunnableWithArgs) {
                        EventRouter.this.fireEvent((RunnableWithArgs)listener, eventHandler, params);
                        continue;
                    }
                    EventRouter.this.fireEvent(listener, eventHandler, params);
                }
            }
        };
    }

    private Object[] asArray(List list) {
        return list.toArray(new Object[list.size()]);
    }

    private void invokeHandler(Object handler, List params) {
        if (handler instanceof Closure) {
            ((Closure)handler).call(this.asArray(params));
        } else if (handler instanceof RunnableWithArgs) {
            ((RunnableWithArgs)handler).run(this.asArray(params));
        }
    }

    private void fireEvent(Script script, String eventHandler, List params) {
        Binding binding = this.scriptBindings.get(script);
        if (binding == null) {
            binding = new Binding();
            script.setBinding(binding);
            script.run();
            this.scriptBindings.put(script, binding);
        }
        this.invokeHandler(binding.getVariable(eventHandler), params);
    }

    private void fireEvent(Map map, String eventHandler, List params) {
        eventHandler = eventHandler.substring(2);
        this.invokeHandler(map.get(eventHandler), params);
    }

    private void fireEvent(Closure closure, String eventHandler, List params) {
        closure.call(this.asArray(params));
    }

    private void fireEvent(RunnableWithArgs runnable, String eventHandler, List params) {
        runnable.run(this.asArray(params));
    }

    private void fireEvent(Object instance, String eventHandler, List params) {
        MetaClass mc = this.metaClassOf(instance);
        MetaProperty mp = mc.getMetaProperty(eventHandler);
        if (mp != null && mp.getProperty(instance) != null) {
            this.invokeHandler(mp.getProperty(instance), params);
            return;
        }
        Class[] argTypes = MetaClassHelper.convertToTypeArray((Object[])this.asArray(params));
        MetaMethod mm = mc.pickMethod(eventHandler, argTypes);
        if (mm != null) {
            mm.invoke(instance, this.asArray(params));
        }
    }

    private MetaClass metaClassOf(Object obj) {
        if (obj instanceof GriffonArtifact) {
            return ((GriffonArtifact)obj).getGriffonClass().getMetaClass();
        }
        if (obj instanceof GroovyObject) {
            return ((GroovyObject)obj).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(obj.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(Object listener) {
        if (listener == null || listener instanceof Closure || listener instanceof RunnableWithArgs) {
            return;
        }
        if (listener instanceof Map) {
            this.addEventListener((Map)listener);
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                return;
            }
            try {
                LOG.debug("Adding listener " + listener);
            }
            catch (UnsupportedOperationException uoe) {
                LOG.debug("Adding listener " + listener.getClass().getName());
            }
            this.listeners.add(listener);
        }
    }

    public void addEventListener(Map<String, Object> listener) {
        if (listener == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : listener.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Closure) {
                this.addEventListener(entry.getKey(), (Closure)value);
                continue;
            }
            if (!(value instanceof RunnableWithArgs)) continue;
            this.addEventListener(entry.getKey(), (RunnableWithArgs)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(Object listener) {
        if (listener == null || listener instanceof Closure || listener instanceof RunnableWithArgs) {
            return;
        }
        if (listener instanceof Map) {
            this.removeEventListener((Map)listener);
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Removing listener " + listener);
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.debug("Removing listener " + listener.getClass().getName());
                }
            }
            this.listeners.remove(listener);
            this.removeNestedListeners(listener);
        }
    }

    public void removeEventListener(Map<String, Object> listener) {
        if (listener == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : listener.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Closure) {
                this.removeEventListener(entry.getKey(), (Closure)value);
                continue;
            }
            if (!(value instanceof RunnableWithArgs)) continue;
            this.removeEventListener(entry.getKey(), (RunnableWithArgs)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(String eventName, Closure listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            ArrayList<Closure> list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list == null) {
                list = new ArrayList<Closure>();
                this.closureListeners.put(GriffonNameUtils.capitalize(eventName), list);
            }
            if (list.contains(listener)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(String eventName, RunnableWithArgs listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            ArrayList<RunnableWithArgs> list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list == null) {
                list = new ArrayList<RunnableWithArgs>();
                this.closureListeners.put(GriffonNameUtils.capitalize(eventName), list);
            }
            if (list.contains(listener)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(String eventName, Closure listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            List list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                }
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(String eventName, RunnableWithArgs listener) {
        if (GriffonNameUtils.isBlank(eventName) || listener == null) {
            return;
        }
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            List list = this.closureListeners.get(GriffonNameUtils.capitalize(eventName));
            if (list != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                }
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNestedListeners(Object subject) {
        Map<String, List> map = this.closureListeners;
        synchronized (map) {
            for (Map.Entry<String, List> event : this.closureListeners.entrySet()) {
                String eventName = event.getKey();
                List listenerList = event.getValue();
                ArrayList toRemove = new ArrayList();
                for (Object listener : listenerList) {
                    if (!this.isNestedListener(listener, subject)) continue;
                    toRemove.add(listener);
                }
                for (Object listener : toRemove) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Removing listener " + listener.getClass().getName() + " on " + GriffonNameUtils.capitalize(eventName));
                    }
                    listenerList.remove(listener);
                }
            }
        }
    }

    private boolean isNestedListener(Object listener, Object subject) {
        Class<?> listenerClass;
        if (listener instanceof Closure) {
            return ((Closure)listener).getOwner().equals(subject);
        }
        if (listener instanceof RunnableWithArgs && (listenerClass = listener.getClass()).isMemberClass() && listenerClass.getEnclosingClass().equals(subject.getClass())) {
            return subject.equals(InvokerHelper.getProperty((Object)listener, (String)"this$0"));
        }
        return false;
    }
}

