/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupConfiguration;
import griffon.exceptions.MVCGroupInstantiationException;
import griffon.util.CollectionUtils;
import griffon.util.ConfigUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import groovy.lang.Binding;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.util.FactoryBuilderSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.griffon.runtime.builder.CompositeBuilderHelper;
import org.codehaus.griffon.runtime.core.AbstractMVCGroupManager;
import org.codehaus.griffon.runtime.core.DefaultMVCGroup;
import org.codehaus.griffon.runtime.core.DefaultMVCGroupConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMVCGroupManager
extends AbstractMVCGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMVCGroupManager.class);
    private static final String CONFIG_KEY_COMPONENT = "component";
    private static final String CONFIG_KEY_EVENTS_LIFECYCLE = "events.lifecycle";
    private static final String CONFIG_KEY_EVENTS_INSTANTIATION = "events.instantiation";
    private static final String CONFIG_KEY_EVENTS_LISTENER = "events.listener";

    public DefaultMVCGroupManager(GriffonApplication app) {
        super(app);
    }

    @Override
    public MVCGroupConfiguration newMVCGroupConfiguration(String mvcType, Map<String, String> members, Map<String, Object> config) {
        return new DefaultMVCGroupConfiguration(this.getApp(), mvcType, members, config);
    }

    @Override
    public MVCGroup newMVCGroup(MVCGroupConfiguration configuration, String mvcId, Map<String, Object> members) {
        return new DefaultMVCGroup(this.getApp(), configuration, mvcId, members);
    }

    @Override
    protected void doInitialize(Map<String, MVCGroupConfiguration> configurations) {
        for (MVCGroupConfiguration configuration : configurations.values()) {
            this.addConfiguration(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MVCGroup buildMVCGroup(MVCGroupConfiguration configuration, String mvcId, Map<String, Object> args) {
        if (args == null) {
            args = Collections.EMPTY_MAP;
        }
        boolean component = DefaultTypeTransformation.castToBoolean((Object)configuration.getConfig().get(CONFIG_KEY_COMPONENT));
        boolean checkId = true;
        if (GriffonNameUtils.isBlank(mvcId)) {
            if (component) {
                checkId = false;
            } else {
                mvcId = configuration.getMvcType();
            }
        }
        if (checkId) {
            this.checkIdIsUnique(mvcId, configuration);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Building MVC group '" + configuration.getMvcType() + "' with name '" + mvcId + "'");
        }
        Map<String, Object> argsCopy = this.copyAndConfigureArguments(args, configuration, mvcId);
        LinkedHashMap<String, MetaClass> metaClassMap = new LinkedHashMap<String, MetaClass>();
        LinkedHashMap<String, Class> klassMap = new LinkedHashMap<String, Class>();
        LinkedHashMap<String, GriffonClass> griffonClassMap = new LinkedHashMap<String, GriffonClass>();
        for (Map.Entry<String, String> memberEntry : configuration.getMembers().entrySet()) {
            String memberType = memberEntry.getKey();
            String memberClassName = memberEntry.getValue();
            this.selectClassesPerMember(memberType, memberClassName, klassMap, metaClassMap, griffonClassMap);
        }
        FactoryBuilderSupport builder = CompositeBuilderHelper.createBuilder(this.getApp(), metaClassMap);
        boolean isEventPublishingEnabled = this.getApp().isEventPublishingEnabled();
        this.getApp().setEventPublishingEnabled(this.isConfigFlagEnabled(configuration, CONFIG_KEY_EVENTS_INSTANTIATION));
        Map<String, Object> instances = null;
        try {
            instances = this.instantiateMembers(klassMap, argsCopy, griffonClassMap, builder);
        }
        finally {
            this.getApp().setEventPublishingEnabled(isEventPublishingEnabled);
        }
        instances.put("builder", builder);
        argsCopy.put("builder", builder);
        MVCGroup group = this.newMVCGroup(configuration, mvcId, instances);
        argsCopy.put("mvcName", group.getMvcId());
        argsCopy.put("mvcId", group.getMvcId());
        argsCopy.put("mvcGroup", group);
        for (Map.Entry<String, Object> variable : argsCopy.entrySet()) {
            builder.setVariable(variable.getKey(), variable.getValue());
        }
        boolean fireEvents = this.isConfigFlagEnabled(configuration, CONFIG_KEY_EVENTS_LIFECYCLE);
        if (fireEvents) {
            this.getApp().event(GriffonApplication.Event.INITIALIZE_MVC_GROUP.getName(), Arrays.asList(configuration, group));
        }
        if (this.isConfigFlagEnabled(group.getConfiguration(), CONFIG_KEY_EVENTS_LISTENER)) {
            this.getApp().addApplicationEventListener(group.getController());
        }
        this.fillReferencedProperties(group, argsCopy);
        if (checkId) {
            this.doAddGroup(group);
        }
        this.initializeMembers(group, argsCopy);
        if (fireEvents) {
            this.getApp().event(GriffonApplication.Event.CREATE_MVC_GROUP.getName(), Arrays.asList(group));
        }
        return group;
    }

    protected void selectClassesPerMember(String memberType, String memberClassName, Map<String, Class> klassMap, Map<String, MetaClass> metaClassMap, Map<String, GriffonClass> griffonClassMap) {
        GriffonClass griffonClass = this.getApp().getArtifactManager().findGriffonClass(memberClassName);
        Class klass = griffonClass != null ? griffonClass.getClazz() : this.loadClass(memberClassName);
        MetaClass metaClass = griffonClass != null ? griffonClass.getMetaClass() : GroovySystem.getMetaClassRegistry().getMetaClass(klass);
        klassMap.put(memberType, klass);
        metaClassMap.put(memberType, metaClass);
        griffonClassMap.put(memberType, griffonClass);
    }

    protected Map<String, Object> copyAndConfigureArguments(Map<String, Object> args, MVCGroupConfiguration configuration, String mvcId) {
        CollectionUtils.MapBuilder<String, Object> argsCopy = CollectionUtils.map().e("app", this.getApp()).e("mvcType", (GriffonApplication)((Object)configuration.getMvcType())).e("mvcName", (GriffonApplication)((Object)mvcId)).e("mvcId", (GriffonApplication)((Object)mvcId)).e("configuration", (GriffonApplication)((Object)configuration));
        argsCopy.putAll(this.getApp().getBindings().getVariables());
        argsCopy.putAll(args);
        return argsCopy;
    }

    protected void checkIdIsUnique(String mvcId, MVCGroupConfiguration configuration) {
        if (this.findGroup(mvcId) != null) {
            String action = ConfigUtils.getConfigValueAsString((Map)this.getApp().getConfig(), "griffon.mvcid.collision", "exception");
            if ("warning".equalsIgnoreCase(action)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("A previous instance of MVC group '" + configuration.getMvcType() + "' with name '" + mvcId + "' exists. Destroying the old instance first.");
                    this.destroyMVCGroup(mvcId);
                }
            } else {
                throw new MVCGroupInstantiationException("Can not instantiate MVC group '" + configuration.getMvcType() + "' with name '" + mvcId + "' because a previous instance with that name exists and was not disposed off properly.", configuration.getMvcType(), mvcId);
            }
        }
    }

    protected Map<String, Object> instantiateMembers(Map<String, Class> klassMap, Map<String, Object> args, Map<String, GriffonClass> griffonClassMap, FactoryBuilderSupport builder) {
        LinkedHashMap<String, Object> instanceMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Class> classEntry : klassMap.entrySet()) {
            String memberType = classEntry.getKey();
            Class memberClass = classEntry.getValue();
            if (args.containsKey(memberType)) {
                instanceMap.put(memberType, args.get(memberType));
                continue;
            }
            GriffonClass griffonClass = griffonClassMap.get(memberType);
            Object instance = null;
            instance = griffonClass != null ? griffonClass.newInstance() : this.getApp().newInstance(memberClass, memberType);
            instanceMap.put(memberType, instance);
            args.put(memberType, instance);
            if (!(instance instanceof Script)) continue;
            builder.getVariables().putAll(((Script)instance).getBinding().getVariables());
            ((Script)instance).setBinding((Binding)builder);
        }
        return instanceMap;
    }

    protected void initializeMembers(MVCGroup group, Map<String, Object> args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing each MVC member of group '" + group.getMvcId() + "'");
        }
        for (Map.Entry<String, Object> memberEntry : group.getMembers().entrySet()) {
            String memberType = memberEntry.getKey();
            Object member = memberEntry.getValue();
            if (member instanceof Script) {
                group.buildScriptMember(memberType);
                continue;
            }
            if ("builder".equalsIgnoreCase(memberType)) continue;
            try {
                InvokerHelper.invokeMethod((Object)member, (String)"mvcGroupInit", (Object)new Object[]{args});
            }
            catch (MissingMethodException mme) {
                if (!"mvcGroupInit".equals(mme.getMethod())) continue;
                throw mme;
            }
        }
    }

    protected void fillReferencedProperties(MVCGroup group, Map<String, Object> args) {
        for (Object member : group.getMembers().values()) {
            if (member instanceof Script) {
                ((Script)member).getBinding().getVariables().putAll(args);
                continue;
            }
            InvokerHelper.setProperties((Object)member, args);
        }
    }

    protected void doAddGroup(MVCGroup group) {
        this.addGroup(group);
    }

    @Override
    public void destroyMVCGroup(String mvcId) {
        MVCGroup group;
        block11: {
            group = this.findGroup(mvcId);
            if (LOG.isDebugEnabled()) {
                LOG.trace("Group '" + mvcId + "' points to " + group);
            }
            if (group == null) {
                return;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Destroying MVC group identified by '" + mvcId + "'");
            }
            if (this.isConfigFlagEnabled(group.getConfiguration(), CONFIG_KEY_EVENTS_LISTENER)) {
                this.getApp().removeApplicationEventListener(group.getController());
            }
            for (Map.Entry<String, Object> memberEntry : group.getMembers().entrySet()) {
                String memberType = memberEntry.getKey();
                Object member = memberEntry.getValue();
                if ("builder".equalsIgnoreCase(memberType) || member == null || member instanceof Script) continue;
                try {
                    InvokerHelper.invokeMethod((Object)member, (String)"mvcGroupDestroy", (Object)new Object[0]);
                }
                catch (MissingMethodException mme) {
                    if (!"mvcGroupDestroy".equals(mme.getMethod())) continue;
                    throw mme;
                }
            }
            try {
                if (group.getBuilder() != null) {
                    group.getBuilder().dispose();
                    group.getBuilder().getVariables().clear();
                }
            }
            catch (MissingMethodException mme) {
                if (!LOG.isErrorEnabled()) break block11;
                LOG.error("Application encountered an error while destroying group '" + mvcId + "'", GriffonExceptionHandler.sanitize(mme));
            }
        }
        this.doRemoveGroup(group);
        group.destroy();
        if (this.isConfigFlagEnabled(group.getConfiguration(), CONFIG_KEY_EVENTS_LIFECYCLE)) {
            this.getApp().event(GriffonApplication.Event.DESTROY_MVC_GROUP.getName(), Arrays.asList(group));
        }
    }

    protected void doRemoveGroup(MVCGroup group) {
        this.removeGroup(group);
    }

    protected Class loadClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected boolean isConfigFlagEnabled(MVCGroupConfiguration configuration, String key) {
        return ConfigUtils.getConfigValueAsBoolean(configuration.getConfig(), key, true);
    }
}

