/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ArtifactHandler;
import griffon.core.ArtifactInfo;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArtifactHandlerAdapter
implements ArtifactHandler {
    private final String type;
    private final String trailing;
    private final GriffonApplication app;
    private ArtifactInfo[] artifacts = new ArtifactInfo[0];
    private GriffonClass[] classes = new GriffonClass[0];
    private Map<String, GriffonClass> classesByName = new TreeMap<String, GriffonClass>();

    public ArtifactHandlerAdapter(GriffonApplication app, String type, String trailing) {
        this.app = app;
        this.type = type;
        this.trailing = trailing == null ? "" : trailing;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTrailing() {
        return this.trailing;
    }

    @Override
    public void initialize(ArtifactInfo[] artifacts) {
        this.artifacts = new ArtifactInfo[artifacts.length];
        System.arraycopy(artifacts, 0, this.artifacts, 0, artifacts.length);
        this.classes = new GriffonClass[artifacts.length];
        for (int i = 0; i < artifacts.length; ++i) {
            Class clazz = artifacts[i].getClazz();
            this.classes[i] = this.newGriffonClassInstance(clazz);
            this.classesByName.put(clazz.getName(), this.classes[i]);
        }
    }

    protected abstract GriffonClass newGriffonClassInstance(Class var1);

    public Map<String, GriffonClass> getClassesByName() {
        return Collections.unmodifiableMap(this.classesByName);
    }

    @Override
    public boolean isArtifact(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.classesByName.get(clazz.getName()) != null;
    }

    @Override
    public boolean isArtifact(GriffonClass clazz) {
        for (GriffonClass griffonClass : this.classes) {
            if (!griffonClass.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GriffonClass[] getClasses() {
        return this.classes;
    }

    public ArtifactInfo[] getArtifacts() {
        return this.artifacts;
    }

    @Override
    public GriffonClass getClassFor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.getClassFor(clazz.getName());
    }

    @Override
    public GriffonClass getClassFor(String fqnClassName) {
        if (GriffonNameUtils.isBlank(fqnClassName)) {
            return null;
        }
        return this.classesByName.get(fqnClassName);
    }

    @Override
    public GriffonClass findClassFor(String propertyName) {
        if (GriffonNameUtils.isBlank(propertyName)) {
            return null;
        }
        String simpleName = propertyName;
        int lastDot = propertyName.lastIndexOf(".");
        if (lastDot > -1) {
            simpleName = simpleName.substring(lastDot + 1);
        }
        if (!(simpleName = simpleName.length() == 1 ? simpleName.toUpperCase() : simpleName.substring(0, 1).toUpperCase() + simpleName.substring(1)).endsWith(this.trailing)) {
            simpleName = simpleName + this.trailing;
        }
        for (GriffonClass griffonClass : this.classes) {
            if (!griffonClass.getClazz().getSimpleName().equals(simpleName)) continue;
            return griffonClass;
        }
        return null;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }
}

