/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RunMode {
    STANDALONE,
    WEBSTART,
    APPLET,
    CUSTOM;

    public static final String KEY = "griffon.runmode";
    public static final String DEFAULT = "griffon.runmode.default";
    private static final String STANDALONE_RUNMODE_SHORT_NAME = "standalone";
    private static final String WEBSTART_RUNMODE_SHORT_NAME = "webstart";
    private static final String APPLET_RUNMODE_SHORT_NAME = "applet";
    private static HashMap<String, String> modeNameMappings;
    private String name;

    public static RunMode getCurrent() {
        String modeName = System.getProperty(KEY);
        if (RunMode.isBlank(modeName)) {
            return STANDALONE;
        }
        RunMode mode = RunMode.getRunMode(modeName);
        if (mode == null) {
            try {
                mode = RunMode.valueOf(modeName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (mode == null) {
            mode = CUSTOM;
            mode.setName(modeName);
        }
        return mode;
    }

    public static RunMode getCurrentRunMode() {
        return RunMode.getCurrent();
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static RunMode getRunMode(String shortName) {
        String modeName = modeNameMappings.get(shortName);
        if (modeName != null) {
            return RunMode.valueOf(modeName.toUpperCase());
        }
        return null;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        if (this.name == null) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        modeNameMappings = new HashMap<String, String>(){
            {
                this.put(RunMode.STANDALONE_RUNMODE_SHORT_NAME, STANDALONE.getName());
                this.put(RunMode.WEBSTART_RUNMODE_SHORT_NAME, WEBSTART.getName());
                this.put(RunMode.APPLET_RUNMODE_SHORT_NAME, APPLET.getName());
            }
        };
    }
}

