/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="java", description="Executes a Java standard application.")
public class JavaAction
extends AbstractAction {
    @Option(name="-m", aliases={"--method"}, description="Invoke a named method", required=false, multiValued=false)
    private String methodName = "main";
    @Argument(index=0, name="className", description="The name of the class to invoke", required=true, multiValued=false)
    private String className;
    @Argument(index=1, name="arguments", description="Arguments to pass to the method of the given class", required=false, multiValued=false)
    private List<String> args;

    protected Object doExecute() throws Exception {
        boolean info = this.log.isInfoEnabled();
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        if (info) {
            this.log.info("Using type: " + type);
        }
        Method method = type.getMethod(this.methodName, String[].class);
        if (info) {
            this.log.info("Using method: " + method);
        }
        if (info) {
            this.log.info("Invoking w/arguments: {}", this.args);
        }
        Object result = method.invoke(null, this.args);
        if (info) {
            this.log.info("Result: " + result);
        }
        return null;
    }
}

