/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    int current = 0;
    String text;
    boolean escaped;
    static final String SPECIAL = "<;|{[\"'$`(=";
    List<List<List<String>>> program;
    List<List<String>> statements;
    List<String> statement;
    int cursor;
    int start = -1;
    int c0;
    int c1;
    int c2;
    int c3;

    public Parser(String text, int cursor) {
        this.text = text;
        this.cursor = cursor;
    }

    void ws() {
        while (!this.eof() && (!this.escaped && Character.isWhitespace(this.peek()) || this.current == 0)) {
            if (this.current != 0 || !this.escaped && Character.isWhitespace(this.peek())) {
                ++this.current;
            }
            if (this.peek() == '/' && this.current < this.text.length() - 2 && this.text.charAt(this.current + 1) == '/') {
                this.comment();
            }
            if (this.current != 0) continue;
            break;
        }
    }

    private void comment() {
        while (!this.eof() && this.peek() != '\n' && this.peek() != '\r') {
            this.next();
        }
    }

    boolean eof() {
        return this.current >= this.text.length();
    }

    char peek() {
        return this.peek(false);
    }

    char peek(boolean increment) {
        int c;
        this.escaped = false;
        if (this.eof()) {
            return '\u0000';
        }
        int last = this.current;
        if ((c = this.text.charAt(this.current++)) == 92) {
            this.escaped = true;
            if (this.eof()) {
                throw new RuntimeException("Eof found after \\");
            }
            c = this.text.charAt(this.current++);
            switch (c) {
                case 116: {
                    c = 9;
                    break;
                }
                case 10: 
                case 13: {
                    c = 32;
                    break;
                }
                case 98: {
                    c = 8;
                    break;
                }
                case 102: {
                    c = 12;
                    break;
                }
                case 110: {
                    c = 10;
                    break;
                }
                case 114: {
                    c = 13;
                    break;
                }
                case 117: {
                    c = this.unicode();
                    this.current += 4;
                    break;
                }
            }
        }
        if (this.cursor > last && this.cursor <= this.current) {
            this.c0 = this.program != null ? this.program.size() : 0;
            this.c1 = this.statements != null ? this.statements.size() : 0;
            this.c2 = this.statement != null ? this.statement.size() : 0;
            int n = this.c3 = this.start >= 0 ? this.current - this.start : 0;
        }
        if (!increment) {
            this.current = last;
        }
        return (char)c;
    }

    public List<List<List<String>>> program() {
        this.program = new ArrayList<List<List<String>>>();
        this.ws();
        if (!this.eof()) {
            this.program.add(this.pipeline());
            while (this.peek() == ';') {
                ++this.current;
                List<List<String>> pipeline = this.pipeline();
                this.program.add(pipeline);
            }
        }
        if (!this.eof()) {
            throw new RuntimeException("Program has trailing text: " + this.context(this.current));
        }
        List<List<List<String>>> p = this.program;
        this.program = null;
        return p;
    }

    CharSequence context(int around) {
        return this.text.subSequence(Math.max(0, this.current - 20), Math.min(this.text.length(), this.current + 4));
    }

    public List<List<String>> pipeline() {
        this.statements = new ArrayList<List<String>>();
        this.statements.add(this.statement());
        while (this.peek() == '|') {
            ++this.current;
            this.ws();
            if (!this.eof()) {
                this.statements.add(this.statement());
                continue;
            }
            this.statements.add(new ArrayList());
            break;
        }
        List<List<String>> s = this.statements;
        this.statements = null;
        return s;
    }

    public List<String> statement() {
        this.statement = new ArrayList<String>();
        this.statement.add(this.value());
        while (!this.eof()) {
            this.ws();
            if (this.peek() == '|' || this.peek() == ';') break;
            if (this.eof()) continue;
            this.statement.add(this.messy());
        }
        List<String> s = this.statement;
        this.statement = null;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String messy() {
        this.start = this.current++;
        char c = this.peek();
        if (c > '\u0000' && SPECIAL.indexOf(c) < 0) {
            try {
                while (!this.eof()) {
                    c = this.peek();
                    if (!this.escaped && (c == ';' || c == '|' || Character.isWhitespace(c))) break;
                    this.next();
                }
                String string = this.text.substring(this.start, this.current);
                return string;
            }
            finally {
                this.start = -1;
            }
        }
        return this.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String value() {
        this.ws();
        this.start = this.current;
        try {
            char c = this.next();
            if (!this.escaped) {
                switch (c) {
                    case '{': {
                        String string = this.text.substring(this.start, this.find('}', '{'));
                        return string;
                    }
                    case '(': {
                        String string = this.text.substring(this.start, this.find(')', '('));
                        return string;
                    }
                    case '[': {
                        String string = this.text.substring(this.start, this.find(']', '['));
                        return string;
                    }
                    case '<': {
                        String string = this.text.substring(this.start, this.find('>', '<'));
                        return string;
                    }
                    case '=': {
                        String string = this.text.substring(this.start, this.current);
                        return string;
                    }
                    case '\"': 
                    case '\'': {
                        this.quote(c);
                    }
                }
            }
            while (!this.eof()) {
                c = this.peek();
                if (!this.escaped) {
                    if (Character.isWhitespace(c) || c == ';' || c == '|' || c == '=') break;
                    if (c == '{') {
                        this.next();
                        this.find('}', '{');
                        continue;
                    }
                    if (c == '(') {
                        this.next();
                        this.find(')', '(');
                        continue;
                    }
                    if (c == '<') {
                        this.next();
                        this.find('>', '<');
                        continue;
                    }
                    if (c == '[') {
                        this.next();
                        this.find(']', '[');
                        continue;
                    }
                    if (c == '\'' || c == '\"') {
                        this.next();
                        this.quote(c);
                        this.next();
                        continue;
                    }
                    this.next();
                    continue;
                }
                this.next();
            }
            String string = this.text.substring(this.start, this.current);
            return string;
        }
        finally {
            this.start = -1;
        }
    }

    boolean escaped() {
        return this.escaped;
    }

    char next() {
        return this.peek(true);
    }

    char unicode() {
        if (this.current + 4 > this.text.length()) {
            throw new IllegalArgumentException("Unicode \\u escape at eof at pos ..." + this.context(this.current) + "...");
        }
        String s = ((Object)this.text.subSequence(this.current, this.current + 4)).toString();
        int n = Integer.parseInt(s, 16);
        return (char)n;
    }

    int find(char target, char deeper) {
        int start = this.current;
        int level = 1;
        while (level != 0) {
            if (this.eof()) {
                throw new RuntimeException("Eof found in the middle of a compound for '" + target + deeper + "', begins at " + this.context(start));
            }
            char c = this.next();
            if (this.escaped) continue;
            if (c == target) {
                --level;
                continue;
            }
            if (c == deeper) {
                ++level;
                continue;
            }
            if (c == '\"') {
                this.quote('\"');
                continue;
            }
            if (c == '\'') {
                this.quote('\'');
                continue;
            }
            if (c != '`') continue;
            this.quote('`');
        }
        return this.current;
    }

    int quote(char which) {
        while (!this.eof() && (this.peek() != which || this.escaped)) {
            this.next();
        }
        return this.current++;
    }

    CharSequence findVar() {
        int start = this.current;
        char c = this.peek();
        if (c == '{') {
            this.next();
            int end = this.find('}', '{');
            return this.text.subSequence(start, end);
        }
        if (c == '(') {
            this.next();
            int end = this.find(')', '(');
            return this.text.subSequence(start, end);
        }
        if (Character.isJavaIdentifierPart(c)) {
            while (c == '$') {
                c = this.next();
            }
            while (!this.eof() && (Character.isJavaIdentifierPart(c) || c == '.') && c != '$') {
                this.next();
                c = this.peek();
            }
            return this.text.subSequence(start, this.current);
        }
        throw new IllegalArgumentException("Reference to variable does not match syntax of a variable: " + this.context(start));
    }

    public String toString() {
        return "..." + this.context(this.current) + "...";
    }

    public String unescape() {
        StringBuilder sb = new StringBuilder();
        while (!this.eof()) {
            sb.append(this.next());
        }
        return sb.toString();
    }
}

