/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Stack;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.proxy.InvocationHandlerWrapper;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collaborator
implements InvocationHandlerWrapper,
Serializable {
    private static final long serialVersionUID = -58189302118314469L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Collaborator.class);
    private transient List<Interceptor> interceptors = null;
    private transient ComponentMetadata cm = null;

    public Collaborator(ComponentMetadata cm, List<Interceptor> interceptors) {
        this.cm = cm;
        this.interceptors = interceptors;
    }

    private void preCallInterceptor(List<Interceptor> interceptorList, ComponentMetadata cm, Method m, Object[] parameters, Stack<StackElement> calledInterceptors) throws Throwable {
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (Interceptor im : interceptorList) {
                StackElement se = new StackElement(im);
                calledInterceptors.push(se);
                se.setPreCallToken(im.preCall(cm, m, parameters));
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args, InvocationHandler target) throws Throwable {
        Object toReturn = null;
        Stack<StackElement> calledInterceptors = new Stack<StackElement>();
        boolean inInvoke = false;
        try {
            this.preCallInterceptor(this.interceptors, this.cm, method, args, calledInterceptors);
            inInvoke = true;
            toReturn = target.invoke(proxy, method, args);
            inInvoke = false;
            this.postCallInterceptorWithReturn(this.cm, method, toReturn, calledInterceptors);
        }
        catch (Throwable e) {
            Throwable exceptionToRethrow;
            block11: {
                LOGGER.debug("invoke", e);
                exceptionToRethrow = null;
                if (!inInvoke) {
                    exceptionToRethrow = e;
                } else if (!(e instanceof RuntimeException)) {
                    exceptionToRethrow = e;
                }
                try {
                    this.postCallInterceptorWithException(this.cm, method, e, calledInterceptors);
                }
                catch (Exception f) {
                    if (exceptionToRethrow == null) {
                        exceptionToRethrow = f;
                        break block11;
                    }
                    LOGGER.warn("Discarding post-call with interceptor exception", (Throwable)f);
                }
            }
            if (exceptionToRethrow == null) {
                exceptionToRethrow = e;
            } else if (exceptionToRethrow != e) {
                LOGGER.warn("Discarding initial exception", e);
            }
            throw exceptionToRethrow;
        }
        return toReturn;
    }

    private void postCallInterceptorWithReturn(ComponentMetadata cm, Method method, Object returnType, Stack<StackElement> calledInterceptors) throws Throwable {
        while (!calledInterceptors.isEmpty()) {
            StackElement se = calledInterceptors.pop();
            try {
                se.interceptor.postCallWithReturn(cm, method, returnType, se.getPreCallToken());
            }
            catch (Throwable t) {
                LOGGER.debug("postCallInterceptorWithReturn", t);
                throw t;
            }
        }
    }

    private void postCallInterceptorWithException(ComponentMetadata cm, Method method, Throwable exception, Stack<StackElement> calledInterceptors) throws Throwable {
        Throwable tobeRethrown = null;
        while (!calledInterceptors.isEmpty()) {
            StackElement se = calledInterceptors.pop();
            try {
                se.interceptor.postCallWithException(cm, method, exception, se.getPreCallToken());
            }
            catch (Throwable t) {
                LOGGER.debug("postCallInterceptorWithException", t);
                if (tobeRethrown == null) {
                    tobeRethrown = t;
                    continue;
                }
                LOGGER.warn("Discarding post-call with interceptor exception", t);
            }
        }
        if (tobeRethrown != null) {
            throw tobeRethrown;
        }
    }

    private static class StackElement {
        private final Interceptor interceptor;
        private Object preCallToken;

        private StackElement(Interceptor i) {
            this.interceptor = i;
        }

        private void setPreCallToken(Object preCallToken) {
            this.preCallToken = preCallToken;
        }

        private Object getPreCallToken() {
            return this.preCallToken;
        }
    }
}

