/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.GroovyClassLoader;
import io.micronaut.core.annotation.Internal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;

@Internal
public class InMemoryByteCodeGroovyClassLoader
extends GroovyClassLoader {
    private Map<String, byte[]> generatedClasses = new ConcurrentHashMap<String, byte[]>();
    private List<URL> generatedUrls = new ArrayList<URL>();
    private Map<String, Class> loadedClasses = new ConcurrentHashMap<String, Class>();

    public InMemoryByteCodeGroovyClassLoader() {
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader loader) {
        super(loader);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(GroovyClassLoader parent) {
        super(parent);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader parent, CompilerConfiguration config, boolean useConfigurationClasspath) {
        super(parent, config, useConfigurationClasspath);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader, config);
        this.clearCache();
    }

    public void addClass(String name, byte[] code) {
        if (name != null && code != null) {
            this.generatedClasses.put(name, code);
        }
    }

    public void addService(String name, final Set<String> classes) throws MalformedURLException {
        this.generatedUrls.add(new URL(null, "mem:META-INF/services/" + name, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return new URLConnection(u){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() {
                        byte[] data = String.join((CharSequence)"\n", classes).getBytes(StandardCharsets.UTF_8);
                        return new ByteArrayInputStream(data);
                    }
                };
            }
        }));
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.loadedClasses.containsKey(name)) {
            return this.loadedClasses.get(name);
        }
        if (this.generatedClasses.containsKey(name)) {
            Class cls = this.defineClass(name, this.generatedClasses.get(name));
            this.loadedClasses.put(name, cls);
            return cls;
        }
        return super.loadClass(name);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Optional<URL> first = this.generatedUrls.stream().filter(url -> url.getPath().equals(name)).findFirst();
        if (first.isPresent()) {
            return Collections.enumeration(Collections.singletonList(first.get()));
        }
        return super.findResources(name);
    }
}

