/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.visitor.LoadedVisitor;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private static final SoftServiceLoader<TypeElementVisitor> SERVICE_LOADER = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)TypeElementVisitorProcessor.class.getClassLoader());
    private static final Set<String> VISITOR_WARNINGS;
    private static final Set<String> SUPPORTED_ANNOTATION_NAMES;
    private List<LoadedVisitor> loadedVisitors;
    private Collection<TypeElementVisitor> typeElementVisitors;

    static Set<String> getVisitedAnnotationNames() {
        return SUPPORTED_ANNOTATION_NAMES;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeElementVisitors = this.findTypeElementVisitors();
        processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        this.loadedVisitors = new ArrayList<LoadedVisitor>(this.typeElementVisitors.size());
        for (TypeElementVisitor visitor : this.typeElementVisitors) {
            TypeElementVisitor.VisitorKind visitorKind = visitor.getVisitorKind();
            TypeElementVisitor.VisitorKind incrementalProcessorKind = this.getIncrementalProcessorKind();
            if (incrementalProcessorKind != visitorKind) continue;
            try {
                this.loadedVisitors.add(new LoadedVisitor(visitor, this.javaVisitorContext, this.genericUtils, processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(this.loadedVisitors);
        for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
    }

    protected boolean hasVisitors() {
        for (TypeElementVisitor typeElementVisitor : this.typeElementVisitors) {
            if (typeElementVisitor.getVisitorKind() != this.getVisitorKind()) continue;
            return true;
        }
        return false;
    }

    protected List<LoadedVisitor> getLoadedVisitors() {
        return this.loadedVisitors;
    }

    protected TypeElementVisitor.VisitorKind getIncrementalProcessorKind() {
        String type = this.getIncrementalProcessorType();
        if (type.equals("org.gradle.annotation.processing.aggregating")) {
            return TypeElementVisitor.VisitorKind.AGGREGATING;
        }
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.loadedVisitors.isEmpty()) {
            return Collections.emptySet();
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream baseOption = super.getSupportedOptions().stream();
        Stream visitorsOptions = this.typeElementVisitors.stream().map(TypeElementVisitor::getSupportedOptions).flatMap(Collection::stream);
        Stream visitorsAnnotationsOptions = this.typeElementVisitors.stream().filter(tev -> tev.getClass().isAnnotationPresent(SupportedOptions.class)).map(Object::getClass).map(cls -> cls.getAnnotation(SupportedOptions.class)).flatMap(supportedOptions -> Arrays.stream(supportedOptions.value()));
        return Stream.of(baseOption, visitorsAnnotationsOptions, visitorsOptions).flatMap(BaseStream::sequential).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders;
        if (!(this.loadedVisitors.isEmpty() || annotations.size() == 1 && Generated.class.getName().equals(annotations.iterator().next().getQualifiedName().toString()))) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            LinkedHashSet<TypeElement> elements = new LinkedHashSet<TypeElement>();
            for (TypeElement typeElement : annotations) {
                Set<? extends javax.lang.model.element.Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
                this.includeElements(elements, annotatedElements, groovyObjectType);
            }
            Set<? extends javax.lang.model.element.Element> rootElements = roundEnv.getRootElements();
            this.includeElements(elements, rootElements, groovyObjectType);
            if (!elements.isEmpty()) {
                for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                    for (TypeElement typeElement : elements) {
                        if (!loadedVisitor.matches(typeElement)) continue;
                        String className = typeElement.getQualifiedName().toString();
                        typeElement.accept(new ElementVisitor(typeElement, Collections.singletonList(loadedVisitor)), className);
                    }
                }
            }
            for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                try {
                    loadedVisitor.getVisitor().finish((VisitorContext)this.javaVisitorContext);
                }
                catch (Throwable e) {
                    this.error("Error finalizing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(beanDefinitionBuilders = this.javaVisitorContext.getBeanElementBuilders())) {
            try {
                AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, beanDefinitionBuilders);
            }
            catch (IOException e) {
                String message = e.getMessage();
                this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
            this.writeBeanDefinitionsToMetaInf();
        }
        return false;
    }

    private void includeElements(Set<TypeElement> target, Set<? extends javax.lang.model.element.Element> annotatedElements, TypeMirror groovyObjectType) {
        annotatedElements.stream().filter(element -> JavaModelUtils.isClassOrInterface((javax.lang.model.element.Element)element) || JavaModelUtils.isEnum((javax.lang.model.element.Element)element) || JavaModelUtils.isRecord((javax.lang.model.element.Element)element)).map(this.modelUtils::classElementFor).filter(Objects::nonNull).filter(element -> element.getAnnotation(Generated.class) == null).filter(typeElement -> groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)).forEach(target::add);
    }

    @NonNull
    protected Collection<TypeElementVisitor> findTypeElementVisitors() {
        for (String visitorWarning : VISITOR_WARNINGS) {
            this.warning(visitorWarning, new Object[0]);
        }
        return TypeElementVisitorProcessor.findCoreTypeElementVisitors(SERVICE_LOADER, null);
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    @NonNull
    private static Collection<TypeElementVisitor> findCoreTypeElementVisitors(SoftServiceLoader<TypeElementVisitor> serviceLoader, @Nullable Set<String> warnings) {
        HashMap<String, TypeElementVisitor> typeElementVisitors = new HashMap<String, TypeElementVisitor>(10);
        for (ServiceDefinition definition : SERVICE_LOADER) {
            String version;
            Requires.Sdk sdk;
            TypeElementVisitor visitor;
            if (!definition.isPresent()) continue;
            try {
                visitor = (TypeElementVisitor)definition.load();
            }
            catch (Throwable e) {
                if (warnings == null) continue;
                warnings.add("TypeElementVisitor [" + definition.getName() + "] will be ignored due to loading error: " + e.getMessage());
                continue;
            }
            if (visitor == null || !visitor.isEnabled()) continue;
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    if (warnings == null) continue;
                    warnings.add("TypeElementVisitor [" + definition.getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            typeElementVisitors.put(definition.getName(), visitor);
        }
        return typeElementVisitors.values();
    }

    static {
        HashSet<String> warnings = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (TypeElementVisitor typeElementVisitor : TypeElementVisitorProcessor.findCoreTypeElementVisitors(SERVICE_LOADER, warnings)) {
            Set supportedAnnotationNames;
            try {
                supportedAnnotationNames = typeElementVisitor.getSupportedAnnotationNames();
            }
            catch (Throwable e) {
                continue;
            }
            if (supportedAnnotationNames.equals(Collections.singleton("*"))) continue;
            names.addAll(supportedAnnotationNames);
        }
        SUPPORTED_ANNOTATION_NAMES = names;
        VISITOR_WARNINGS = warnings.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(warnings);
    }

    private class ElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final List<LoadedVisitor> visitors;

        ElementVisitor(TypeElement concreteClass, List<LoadedVisitor> visitors) {
            this.concreteClass = concreteClass;
            this.visitors = visitors;
        }

        @Override
        public Object visitUnknown(javax.lang.model.element.Element e, Object o) {
            return o;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            boolean shouldVisit;
            AnnotationMetadata typeAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            for (LoadedVisitor visitor : this.visitors) {
                Element resultingElement = visitor.visit(classElement, typeAnnotationMetadata);
                if (resultingElement == null) continue;
                typeAnnotationMetadata = resultingElement.getAnnotationMetadata();
            }
            javax.lang.model.element.Element enclosingElement = classElement.getEnclosingElement();
            boolean bl = shouldVisit = !JavaModelUtils.isClass((javax.lang.model.element.Element)enclosingElement) || this.concreteClass.getQualifiedName().equals(classElement.getQualifiedName());
            if (shouldVisit) {
                if (typeAnnotationMetadata.hasStereotype(Introduction.class) || typeAnnotationMetadata.hasStereotype(Introspected.class) && TypeElementVisitorProcessor.this.modelUtils.isAbstract(classElement)) {
                    classElement.asType().accept(new PublicAbstractMethodVisitor<Object, Object>(classElement, TypeElementVisitorProcessor.this.javaVisitorContext){

                        @Override
                        protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                            if (element instanceof ExecutableElement) {
                                ElementVisitor.this.visitExecutable((ExecutableElement)element, o);
                            }
                        }
                    }, null);
                    return null;
                }
                if (JavaModelUtils.isEnum((javax.lang.model.element.Element)classElement)) {
                    return this.scan(classElement.getEnclosedElements(), o);
                }
                List<? extends javax.lang.model.element.Element> elements = this.enclosedElements(classElement);
                Object value = null;
                for (javax.lang.model.element.Element element : elements) {
                    value = this.scan(element, o);
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    for (LoadedVisitor visitor : this.visitors) {
                        if (!visitor.matches(typeElement)) continue;
                        value = this.scan(this.enclosedElements(typeElement), o);
                    }
                }
                return value;
            }
            return null;
        }

        private List<? extends javax.lang.model.element.Element> enclosedElements(TypeElement classElement) {
            ArrayList<javax.lang.model.element.Element> enclosedElements = new ArrayList<javax.lang.model.element.Element>(classElement.getEnclosedElements());
            TypeElement superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(classElement);
            while (superClass != null && !TypeElementVisitorProcessor.this.modelUtils.isObjectClass(superClass)) {
                List<? extends javax.lang.model.element.Element> elements = superClass.getEnclosedElements();
                for (javax.lang.model.element.Element element : elements) {
                    if (element instanceof ExecutableElement) {
                        this.checkMethodOverride(enclosedElements, element);
                        continue;
                    }
                    if (!(element instanceof VariableElement)) continue;
                    this.checkFieldHide(enclosedElements, element);
                }
                superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(superClass);
            }
            return enclosedElements;
        }

        private void checkFieldHide(List<javax.lang.model.element.Element> enclosedElements, javax.lang.model.element.Element elt1) {
            boolean hides = false;
            for (javax.lang.model.element.Element elt2 : enclosedElements) {
                if (elt1.equals(elt2) || !(elt2 instanceof VariableElement) || !TypeElementVisitorProcessor.this.elementUtils.hides(elt2, elt1)) continue;
                hides = true;
                break;
            }
            if (!hides) {
                enclosedElements.add(elt1);
            }
        }

        private void checkMethodOverride(List<javax.lang.model.element.Element> enclosedElements, javax.lang.model.element.Element elt1) {
            boolean overrides = false;
            for (javax.lang.model.element.Element elt2 : enclosedElements) {
                if (elt1.equals(elt2) || !(elt2 instanceof ExecutableElement) || !TypeElementVisitorProcessor.this.elementUtils.overrides((ExecutableElement)elt2, (ExecutableElement)elt1, TypeElementVisitorProcessor.this.modelUtils.classElementFor(elt2))) continue;
                overrides = true;
                break;
            }
            if (!overrides) {
                enclosedElements.add(elt1);
            }
        }

        @Override
        public Object visitExecutable(ExecutableElement executableElement, Object o) {
            AnnotationMetadata resolvedMethodMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(executableElement);
            Object methodAnnotationMetadata = resolvedMethodMetadata instanceof AnnotationMetadataHierarchy ? resolvedMethodMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(executableElement.getEnclosingElement()), resolvedMethodMetadata});
            if (executableElement.getSimpleName().toString().equals("<init>")) {
                for (LoadedVisitor visitor : this.visitors) {
                    Element resultingElement = visitor.visit(executableElement, (AnnotationMetadata)methodAnnotationMetadata);
                    if (resultingElement == null) continue;
                    methodAnnotationMetadata = resultingElement.getAnnotationMetadata();
                }
            } else {
                for (LoadedVisitor visitor : this.visitors) {
                    Element resultingElement;
                    if (!visitor.matches((AnnotationMetadata)methodAnnotationMetadata) || (resultingElement = visitor.visit(executableElement, (AnnotationMetadata)methodAnnotationMetadata)) == null) continue;
                    methodAnnotationMetadata = resultingElement.getAnnotationMetadata();
                }
            }
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            for (LoadedVisitor visitor : this.visitors) {
                Element resultingElement;
                if (!visitor.matches(fieldAnnotationMetadata) || (resultingElement = visitor.visit(variable, fieldAnnotationMetadata)) == null) continue;
                fieldAnnotationMetadata = resultingElement.getAnnotationMetadata();
            }
            return null;
        }
    }
}

