/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.CustomLoaderLayout;
import org.springframework.boot.loader.tools.DefaultLayoutFactory;
import org.springframework.boot.loader.tools.Digest;
import org.springframework.boot.loader.tools.InputStreamSupplier;
import org.springframework.boot.loader.tools.JarModeLibrary;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.LayersIndex;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.loader.tools.RepackagingLayout;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class Packager {
    private static final String MAIN_CLASS_ATTRIBUTE = "Main-Class";
    private static final String START_CLASS_ATTRIBUTE = "Start-Class";
    private static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    private static final String BOOT_CLASSES_ATTRIBUTE = "Spring-Boot-Classes";
    private static final String BOOT_LIB_ATTRIBUTE = "Spring-Boot-Lib";
    private static final String BOOT_CLASSPATH_INDEX_ATTRIBUTE = "Spring-Boot-Classpath-Index";
    private static final String BOOT_LAYERS_INDEX_ATTRIBUTE = "Spring-Boot-Layers-Index";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private final List<MainClassTimeoutWarningListener> mainClassTimeoutListeners = new ArrayList<MainClassTimeoutWarningListener>();
    private String mainClass;
    private final File source;
    private File backupFile;
    private Layout layout;
    private LayoutFactory layoutFactory;
    private Layers layers;
    private LayersIndex layersIndex;
    private boolean includeRelevantJarModeJars = true;

    protected Packager(File source) {
        this(source, null);
    }

    @Deprecated
    protected Packager(File source, LayoutFactory layoutFactory) {
        Assert.notNull((Object)source, (String)"Source file must not be null");
        Assert.isTrue((source.exists() && source.isFile() ? 1 : 0) != 0, () -> "Source must refer to an existing file, got " + source.getAbsolutePath());
        this.source = source.getAbsoluteFile();
        this.layoutFactory = layoutFactory;
    }

    public void addMainClassTimeoutWarningListener(MainClassTimeoutWarningListener listener) {
        this.mainClassTimeoutListeners.add(listener);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setLayout(Layout layout) {
        Assert.notNull((Object)layout, (String)"Layout must not be null");
        this.layout = layout;
    }

    public void setLayoutFactory(LayoutFactory layoutFactory) {
        this.layoutFactory = layoutFactory;
    }

    public void setLayers(Layers layers) {
        Assert.notNull((Object)layers, (String)"Layers must not be null");
        this.layers = layers;
        this.layersIndex = new LayersIndex(layers);
    }

    protected void setBackupFile(File backupFile) {
        this.backupFile = backupFile;
    }

    public void setIncludeRelevantJarModeJars(boolean includeRelevantJarModeJars) {
        this.includeRelevantJarModeJars = includeRelevantJarModeJars;
    }

    protected final boolean isAlreadyPackaged() {
        return this.isAlreadyPackaged(this.source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean isAlreadyPackaged(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(BOOT_VERSION_ATTRIBUTE) != null;
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading archive file", ex);
        }
    }

    protected final void write(JarFile sourceJar, Libraries libraries, AbstractJarWriter writer) throws IOException {
        this.write(sourceJar, libraries, writer, false);
    }

    protected final void write(JarFile sourceJar, Libraries libraries, AbstractJarWriter writer, boolean ensureReproducibleBuild) throws IOException {
        Assert.notNull((Object)libraries, (String)"Libraries must not be null");
        this.write(sourceJar, writer, new PackagedLibraries(libraries, ensureReproducibleBuild));
    }

    private void write(JarFile sourceJar, AbstractJarWriter writer, PackagedLibraries libraries) throws IOException {
        if (this.isLayered()) {
            writer.useLayers(this.layers, this.layersIndex);
        }
        writer.writeManifest(this.buildManifest(sourceJar));
        this.writeLoaderClasses(writer);
        writer.writeEntries(sourceJar, this.getEntityTransformer(), libraries.getUnpackHandler(), libraries.getLibraryLookup());
        libraries.write(writer);
        if (this.isLayered()) {
            this.writeLayerIndex(writer);
        }
    }

    private void writeLoaderClasses(AbstractJarWriter writer) throws IOException {
        Layout layout = this.getLayout();
        if (layout instanceof CustomLoaderLayout) {
            ((CustomLoaderLayout)((Object)this.getLayout())).writeLoadedClasses(writer);
        } else if (layout.isExecutable()) {
            writer.writeLoaderClasses();
        }
    }

    private void writeLayerIndex(AbstractJarWriter writer) throws IOException {
        String name = this.layout.getLayersIndexFileLocation();
        if (StringUtils.hasLength((String)name)) {
            Layer layer = this.layers.getLayer(name);
            this.layersIndex.add(layer, name);
            writer.writeEntry(name, this.layersIndex::writeTo);
        }
    }

    private AbstractJarWriter.EntryTransformer getEntityTransformer() {
        if (this.getLayout() instanceof RepackagingLayout) {
            return new RepackagingEntryTransformer((RepackagingLayout)this.getLayout());
        }
        return AbstractJarWriter.EntryTransformer.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZip(InputStreamSupplier supplier) {
        try (InputStream inputStream = supplier.openStream();){
            boolean bl = this.isZip(inputStream);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (byte magicByte : ZIP_FILE_HEADER) {
            if (inputStream.read() == magicByte) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        Manifest manifest = this.createInitialManifest(source);
        this.addMainAndStartAttributes(source, manifest);
        this.addBootAttributes(manifest.getMainAttributes());
        return manifest;
    }

    private Manifest createInitialManifest(JarFile source) throws IOException {
        if (source.getManifest() != null) {
            return new Manifest(source.getManifest());
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        return manifest;
    }

    private void addMainAndStartAttributes(JarFile source, Manifest manifest) throws IOException {
        String mainClass = this.getMainClass(source, manifest);
        String launcherClass = this.getLayout().getLauncherClassName();
        if (launcherClass != null) {
            Assert.state((mainClass != null ? 1 : 0) != 0, (String)"Unable to find main class");
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, launcherClass);
            manifest.getMainAttributes().putValue(START_CLASS_ATTRIBUTE, mainClass);
        } else if (mainClass != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, mainClass);
        }
    }

    private String getMainClass(JarFile source, Manifest manifest) throws IOException {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        String attributeValue = manifest.getMainAttributes().getValue(MAIN_CLASS_ATTRIBUTE);
        if (attributeValue != null) {
            return attributeValue;
        }
        return this.findMainMethodWithTimeoutWarning(source);
    }

    private String findMainMethodWithTimeoutWarning(JarFile source) throws IOException {
        long startTime = System.currentTimeMillis();
        String mainMethod = this.findMainMethod(source);
        long duration = System.currentTimeMillis() - startTime;
        if (duration > FIND_WARNING_TIMEOUT) {
            for (MainClassTimeoutWarningListener listener : this.mainClassTimeoutListeners) {
                listener.handleTimeoutWarning(duration, mainMethod);
            }
        }
        return mainMethod;
    }

    protected String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, this.getLayout().getClassesLocation(), SPRING_BOOT_APPLICATION_CLASS_NAME);
    }

    public final File getBackupFile() {
        if (this.backupFile != null) {
            return this.backupFile;
        }
        return new File(this.source.getParentFile(), this.source.getName() + ".original");
    }

    protected final File getSource() {
        return this.source;
    }

    protected final Layout getLayout() {
        if (this.layout == null) {
            Layout createdLayout = this.getLayoutFactory().getLayout(this.source);
            Assert.state((createdLayout != null ? 1 : 0) != 0, (String)"Unable to detect layout");
            this.layout = createdLayout;
        }
        return this.layout;
    }

    private LayoutFactory getLayoutFactory() {
        if (this.layoutFactory != null) {
            return this.layoutFactory;
        }
        List factories = SpringFactoriesLoader.loadFactories(LayoutFactory.class, null);
        if (factories.isEmpty()) {
            return new DefaultLayoutFactory();
        }
        Assert.state((factories.size() == 1 ? 1 : 0) != 0, (String)"No unique LayoutFactory found");
        return (LayoutFactory)factories.get(0);
    }

    private void addBootAttributes(Attributes attributes) {
        attributes.putValue(BOOT_VERSION_ATTRIBUTE, this.getClass().getPackage().getImplementationVersion());
        this.addBootAttributesForLayout(attributes);
    }

    private void addBootAttributesForLayout(Attributes attributes) {
        Layout layout = this.getLayout();
        if (layout instanceof RepackagingLayout) {
            attributes.putValue(BOOT_CLASSES_ATTRIBUTE, ((RepackagingLayout)layout).getRepackagedClassesLocation());
        } else {
            attributes.putValue(BOOT_CLASSES_ATTRIBUTE, layout.getClassesLocation());
        }
        this.putIfHasLength(attributes, BOOT_LIB_ATTRIBUTE, this.getLayout().getLibraryLocation("", LibraryScope.COMPILE));
        this.putIfHasLength(attributes, BOOT_CLASSPATH_INDEX_ATTRIBUTE, layout.getClasspathIndexFileLocation());
        if (this.isLayered()) {
            this.putIfHasLength(attributes, BOOT_LAYERS_INDEX_ATTRIBUTE, layout.getLayersIndexFileLocation());
        }
    }

    private void putIfHasLength(Attributes attributes, String name, String value) {
        if (StringUtils.hasLength((String)value)) {
            attributes.putValue(name, value);
        }
    }

    private boolean isLayered() {
        return this.layers != null;
    }

    private final class PackagedLibraries {
        private final Map<String, Library> libraries;
        private final AbstractJarWriter.UnpackHandler unpackHandler;
        private final Function<JarEntry, Library> libraryLookup;

        PackagedLibraries(Libraries libraries, boolean ensureReproducibleBuild) throws IOException {
            this.libraries = ensureReproducibleBuild ? new TreeMap() : new LinkedHashMap();
            libraries.doWithLibraries(library -> {
                if (Packager.this.isZip(library::openStream)) {
                    this.addLibrary(library);
                }
            });
            if (Packager.this.isLayered() && Packager.this.includeRelevantJarModeJars) {
                this.addLibrary(JarModeLibrary.LAYER_TOOLS);
            }
            this.unpackHandler = new PackagedLibrariesUnpackHandler();
            this.libraryLookup = this::lookup;
        }

        private void addLibrary(Library library) {
            String location = Packager.this.getLayout().getLibraryLocation(library.getName(), library.getScope());
            if (location != null) {
                String path = location + library.getName();
                Library existing = this.libraries.putIfAbsent(path, library);
                Assert.state((existing == null ? 1 : 0) != 0, () -> "Duplicate library " + library.getName());
            }
        }

        private Library lookup(JarEntry entry) {
            return this.libraries.get(entry.getName());
        }

        AbstractJarWriter.UnpackHandler getUnpackHandler() {
            return this.unpackHandler;
        }

        Function<JarEntry, Library> getLibraryLookup() {
            return this.libraryLookup;
        }

        void write(AbstractJarWriter writer) throws IOException {
            ArrayList<String> writtenPaths = new ArrayList<String>();
            for (Map.Entry<String, Library> entry : this.libraries.entrySet()) {
                String path = entry.getKey();
                Library library = entry.getValue();
                if (!library.isIncluded()) continue;
                String location = path.substring(0, path.lastIndexOf(47) + 1);
                writer.writeNestedLibrary(location, library);
                writtenPaths.add(path);
            }
            this.writeClasspathIndexIfNecessary(writtenPaths, Packager.this.getLayout(), writer);
        }

        private void writeClasspathIndexIfNecessary(List<String> paths, Layout layout, AbstractJarWriter writer) throws IOException {
            if (layout.getClasspathIndexFileLocation() != null) {
                List<String> names = paths.stream().map(path -> "- \"" + path + "\"").collect(Collectors.toList());
                writer.writeIndexFile(layout.getClasspathIndexFileLocation(), names);
            }
        }

        private class PackagedLibrariesUnpackHandler
        implements AbstractJarWriter.UnpackHandler {
            private PackagedLibrariesUnpackHandler() {
            }

            @Override
            public boolean requiresUnpack(String name) {
                Library library = (Library)PackagedLibraries.this.libraries.get(name);
                return library != null && library.isUnpackRequired();
            }

            @Override
            public String sha1Hash(String name) throws IOException {
                Library library = (Library)PackagedLibraries.this.libraries.get(name);
                Assert.notNull((Object)library, () -> "No library found for entry name '" + name + "'");
                return Digest.sha1(library::openStream);
            }
        }
    }

    private static final class RepackagingEntryTransformer
    implements AbstractJarWriter.EntryTransformer {
        private final RepackagingLayout layout;

        private RepackagingEntryTransformer(RepackagingLayout layout) {
            this.layout = layout;
        }

        @Override
        public JarArchiveEntry transform(JarArchiveEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (!this.isTransformable(entry)) {
                return entry;
            }
            String transformedName = this.transformName(entry.getName());
            JarArchiveEntry transformedEntry = new JarArchiveEntry(transformedName);
            transformedEntry.setTime(entry.getTime());
            transformedEntry.setSize(entry.getSize());
            transformedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                transformedEntry.setComment(entry.getComment());
            }
            transformedEntry.setCompressedSize(entry.getCompressedSize());
            transformedEntry.setCrc(entry.getCrc());
            if (entry.getCreationTime() != null) {
                transformedEntry.setCreationTime(entry.getCreationTime());
            }
            if (entry.getExtra() != null) {
                transformedEntry.setExtra(entry.getExtra());
            }
            if (entry.getLastAccessTime() != null) {
                transformedEntry.setLastAccessTime(entry.getLastAccessTime());
            }
            if (entry.getLastModifiedTime() != null) {
                transformedEntry.setLastModifiedTime(entry.getLastModifiedTime());
            }
            return transformedEntry;
        }

        private String transformName(String name) {
            return this.layout.getRepackagedClassesLocation() + name;
        }

        private boolean isTransformable(JarArchiveEntry entry) {
            String name = entry.getName();
            if (name.startsWith("META-INF/")) {
                return name.equals("META-INF/aop.xml") || name.endsWith(".kotlin_module");
            }
            return !name.startsWith("BOOT-INF/") && !name.equals("module-info.class");
        }
    }

    @FunctionalInterface
    public static interface MainClassTimeoutWarningListener {
        public void handleTimeoutWarning(long var1, String var3);
    }
}

