/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.EnvironmentConvertibleValuesMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Stream;

@Internal
class EnvironmentAnnotationValue<A extends Annotation>
extends AnnotationValue<A> {
    EnvironmentAnnotationValue(Environment environment, AnnotationValue<A> target) {
        super(target, AnnotationMetadataSupport.getDefaultValues(target.getAnnotationName()), EnvironmentConvertibleValuesMap.of(environment, target.getValues()), environment != null ? o -> {
            PropertyPlaceholderResolver resolver = environment.getPlaceholderResolver();
            if (o instanceof String) {
                String v = (String)o;
                if (v.contains("${")) {
                    return resolver.resolveRequiredPlaceholders(v);
                }
            } else if (o instanceof String[]) {
                String[] values = (String[])o;
                return Arrays.stream(values).flatMap(value -> {
                    try {
                        return Arrays.stream((Object[])resolver.resolveRequiredPlaceholder((String)value, String[].class));
                    }
                    catch (ConfigurationException e) {
                        if (value.contains(resolver.getPrefix())) {
                            value = resolver.resolveRequiredPlaceholders((String)value);
                        }
                        return Stream.of(value);
                    }
                }).toArray(String[]::new);
            }
            return o;
        } : null);
    }
}

