/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test.event;

import grails.build.logging.GrailsConsole;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class GrailsTestRunNotifier
extends RunNotifier {
    int progress = 0;
    int total;
    private GrailsConsole console = GrailsConsole.getInstance();

    public GrailsTestRunNotifier(int total) {
        this.total = total;
    }

    public void fireTestRunFinished(Result result) {
        super.fireTestRunFinished(result);
    }

    public void fireTestStarted(Description description) throws StoppedByUserException {
        this.console.indicateProgress(++this.progress, this.total);
        super.fireTestStarted(description);
    }

    public void fireTestFailure(Failure failure) {
        this.console.error("Failure: ", failure.getDescription().getDisplayName());
        Throwable exception = failure.getException();
        if (exception == null) {
            this.console.error(failure.getMessage());
        } else {
            DefaultStackTraceFilterer filterer = new DefaultStackTraceFilterer();
            filterer.setCutOffPackage("org.junit");
            filterer.filter(exception, true);
            StringWriter sw = new StringWriter();
            PrintWriter ps = new PrintWriter(sw);
            exception.printStackTrace(ps);
            this.console.error("", sw.toString());
        }
        super.fireTestFailure(failure);
    }
}

