/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test.report.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter;
import org.codehaus.groovy.grails.test.support.TestStacktraceSanitizer;

public class PlainFormatter
extends PlainJUnitResultFormatter {
    protected String name;
    protected File file;
    protected String systemOutput;
    protected String systemError;

    public PlainFormatter(String name, File file) {
        this.name = name;
        this.file = file;
        try {
            super.setOutput((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOutput(OutputStream out) {
        throw new IllegalStateException("This should not be called");
    }

    public void setSystemError(String out) {
        this.systemError = out;
        super.setSystemError(out);
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
        super.setSystemOutput(out);
    }

    public void addFailure(Test test, Throwable throwable) {
        TestStacktraceSanitizer.sanitize(throwable);
        super.addFailure(test, throwable);
    }

    public void addError(Test test, Throwable throwable) {
        TestStacktraceSanitizer.sanitize(throwable);
        super.addError(test, throwable);
    }

    public void endTestSuite(JUnitTest suite) {
        super.endTestSuite(suite);
        File parentFile = this.file.getParentFile();
        this.writeToFile(new File(parentFile, this.name + "-out.txt"), this.systemOutput);
        this.writeToFile(new File(parentFile, this.name + "-err.txt"), this.systemError);
    }

    protected void writeToFile(File f, String text) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write(text);
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

