/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.grails.datastore.mapping.annotation.Entity;
import org.grails.datastore.mapping.annotation.Id;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.core.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMappingConfigurationStrategy
implements MappingConfigurationStrategy {
    private static final Set EXCLUDED_PROPERTIES = new HashSet<String>(Arrays.asList("class", "metaClass"));
    private MappingFactory propertyFactory;

    public DefaultMappingConfigurationStrategy(MappingFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    private boolean isExcludedProperty(String propertyName, ClassMapping classMapping, Collection transients) {
        IdentityMapping id = classMapping != null ? classMapping.getIdentifier() : null;
        return id != null && id.getIdentifierName()[0].equals(propertyName) || EXCLUDED_PROPERTIES.contains(propertyName) || transients.contains(propertyName);
    }

    @Override
    public boolean isPersistentEntity(Class javaClass) {
        return AnnotationUtils.findAnnotation((Class)javaClass, Entity.class) != null;
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(Class javaClass, MappingContext context) {
        return this.getPersistentProperties(javaClass, context, null);
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(PersistentEntity entity, MappingContext context, ClassMapping classMapping) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
        PropertyDescriptor[] descriptors = cpf.getPropertyDescriptors();
        ArrayList<PersistentProperty> persistentProperties = new ArrayList<PersistentProperty>();
        for (PropertyDescriptor descriptor : descriptors) {
            String propertyName = descriptor.getName();
            if (this.isExcludedProperty(propertyName, classMapping, Collections.emptyList())) continue;
            Class<?> propertyType = descriptor.getPropertyType();
            if (this.propertyFactory.isSimpleType(propertyType)) {
                persistentProperties.add(this.propertyFactory.createSimple(entity, context, descriptor));
                continue;
            }
            if (!MappingFactory.isCustomType(propertyType)) continue;
            persistentProperties.add(this.propertyFactory.createCustom(entity, context, descriptor));
        }
        return persistentProperties;
    }

    private PersistentEntity getPersistentEntity(Class javaClass, MappingContext context, ClassMapping classMapping) {
        PersistentEntity entity = classMapping != null ? classMapping.getEntity() : context.getPersistentEntity(javaClass.getName());
        return entity;
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(Class javaClass, MappingContext context, ClassMapping mapping) {
        PersistentEntity entity = this.getPersistentEntity(javaClass, context, mapping);
        if (entity != null) {
            return this.getPersistentProperties(entity, context, mapping);
        }
        return Collections.emptyList();
    }

    @Override
    public PersistentProperty getIdentity(Class javaClass, MappingContext context) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(javaClass);
        for (Field field : cpf.getJavaClass().getDeclaredFields()) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            PersistentEntity entity = context.getPersistentEntity(javaClass.getName());
            PropertyDescriptor pd = cpf.getPropertyDescriptor(field.getName());
            return this.propertyFactory.createIdentity(entity, context, pd);
        }
        throw new IllegalMappingException("No identifier specified for persistent class: " + javaClass.getName());
    }

    @Override
    public IdentityMapping getIdentityMapping(ClassMapping classMapping) {
        return this.getDefaultIdentityMapping(classMapping);
    }

    @Override
    public IdentityMapping getDefaultIdentityMapping(final ClassMapping classMapping) {
        PersistentEntity e = classMapping.getEntity();
        final PersistentProperty identity = this.getIdentity(e.getJavaClass(), e.getMappingContext());
        return new IdentityMapping(){

            public String[] getIdentifierName() {
                return new String[]{identity.getName()};
            }

            public ClassMapping getClassMapping() {
                return classMapping;
            }

            public Object getMappedForm() {
                return null;
            }
        };
    }

    @Override
    public Set getOwningEntities(Class javaClass, MappingContext context) {
        return Collections.emptySet();
    }
}

