/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.IsReloadableTypePlugin;
import com.springsource.loaded.agent.ReloadDecision;
import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SystemPropertyConfiguredIsReloadableTypePlugin
implements IsReloadableTypePlugin {
    public static final boolean debug;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private String mostRecentReloadableDirs = null;

    static {
        boolean value = false;
        try {
            value = System.getProperty("springloaded.directoriesContainingReloadableCode.debug", "false").equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = value;
    }

    public SystemPropertyConfiguredIsReloadableTypePlugin() {
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: instantiated");
        }
    }

    public ReloadDecision shouldBeMadeReloadable(String typename, ProtectionDomain protectionDomain, byte[] bytes) {
        CodeSource codeSource;
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: entered, for typename " + typename);
        }
        if (protectionDomain == null) {
            return ReloadDecision.PASS;
        }
        String reloadableDirs = System.getProperty("springloaded.directoriesContainingReloadableCode");
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: reloadableDirs=" + reloadableDirs);
        }
        if (reloadableDirs == null) {
            return ReloadDecision.PASS;
        }
        if (this.mostRecentReloadableDirs != reloadableDirs) {
            this.includes.clear();
            this.excludes.clear();
            StringTokenizer st = new StringTokenizer(reloadableDirs, ",");
            while (st.hasMoreTokens()) {
                boolean isNot;
                String nextDir = st.nextToken();
                boolean bl = isNot = nextDir.charAt(0) == '!';
                if (isNot) {
                    this.excludes.add(nextDir.substring(1));
                    continue;
                }
                this.includes.add(nextDir);
            }
        }
        if ((codeSource = protectionDomain.getCodeSource()) == null || codeSource.getLocation() == null) {
            return ReloadDecision.NO;
        }
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " codeSource.getLocation() is " + codeSource.getLocation());
        }
        try {
            File file = new File(codeSource.getLocation().toURI());
            String path = file.toString();
            for (String exclude : this.excludes) {
                if (!path.contains(exclude)) continue;
                if (debug) {
                    System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is not being made reloadable");
                }
                return ReloadDecision.NO;
            }
            for (String include : this.includes) {
                if (!path.contains(include)) continue;
                if (debug) {
                    System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is being made reloadable");
                }
                return ReloadDecision.YES;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is being PASSed on");
        }
        return ReloadDecision.PASS;
    }
}

