+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "QueryField"
keywords = ["grafana","documentation","sdk","@grafana/ui"]
type = "docs"
+++

## QueryField class

Renders an editor field. Pass initial value as initialQuery and listen to changes in props.onValueChanged. This component can only process strings. Internally it uses Slate Value. Implement props.onTypeahead to use suggestions, see PromQueryField.tsx as an example.

<b>Signature</b>

```typescript
export declare class QueryField extends React.PureComponent<QueryFieldProps, QueryFieldState> 
```
<b>Import</b>

```typescript
import { QueryField } from '@grafana/ui';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(props, context)](#constructor-propscontext) |  | Constructs a new instance of the <code>QueryField</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [editor](#editor-property) |  | <code>Editor &#124; null</code> |  |
|  [handleBlur](#handleblur-property) |  | <code>(event: Event, editor: CoreEditor, next: Function) =&gt; any</code> | We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur. |
|  [lastExecutedValue](#lastexecutedvalue-property) |  | <code>Value &#124; null</code> |  |
|  [mounted](#mounted-property) |  | <code>boolean</code> |  |
|  [onChange](#onchange-property) |  | <code>(value: Value, runQuery?: boolean &#124; undefined) =&gt; void</code> | Update local state, propagate change upstream and optionally run the query afterwards. |
|  [plugins](#plugins-property) |  | <code>Plugin[]</code> |  |
|  [runOnChange](#runonchange-property) |  | <code>() =&gt; void</code> |  |
|  [runOnChangeAndRunQuery](#runonchangeandrunquery-property) |  | <code>() =&gt; void</code> |  |
|  [runOnChangeDebounced](#runonchangedebounced-property) |  | <code>Function</code> |  |
|  [runOnRunQuery](#runonrunquery-property) |  | <code>() =&gt; void</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [componentDidMount()](#componentdidmount-method) |  |  |
|  [componentDidUpdate(prevProps, prevState)](#componentdidupdate-method) |  |  |
|  [componentWillUnmount()](#componentwillunmount-method) |  |  |
|  [render()](#render-method) |  |  |

### constructor(props, context)

Constructs a new instance of the `QueryField` class

<b>Signature</b>

```typescript
constructor(props: QueryFieldProps, context: Context<any>);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  props | <code>QueryFieldProps</code> |  |
|  context | <code>Context&lt;any&gt;</code> |  |

### editor property

<b>Signature</b>

```typescript
editor: Editor | null;
```

### handleBlur property

We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur.

<b>Signature</b>

```typescript
handleBlur: (event: Event, editor: CoreEditor, next: Function) => any;
```

### lastExecutedValue property

<b>Signature</b>

```typescript
lastExecutedValue: Value | null;
```

### mounted property

<b>Signature</b>

```typescript
mounted: boolean;
```

### onChange property

Update local state, propagate change upstream and optionally run the query afterwards.

<b>Signature</b>

```typescript
onChange: (value: Value, runQuery?: boolean | undefined) => void;
```

### plugins property

<b>Signature</b>

```typescript
plugins: Plugin[];
```

### runOnChange property

<b>Signature</b>

```typescript
runOnChange: () => void;
```

### runOnChangeAndRunQuery property

<b>Signature</b>

```typescript
runOnChangeAndRunQuery: () => void;
```

### runOnChangeDebounced property

<b>Signature</b>

```typescript
runOnChangeDebounced: Function;
```

### runOnRunQuery property

<b>Signature</b>

```typescript
runOnRunQuery: () => void;
```

### componentDidMount method

<b>Signature</b>

```typescript
componentDidMount(): void;
```
<b>Returns:</b>

`void`

### componentDidUpdate method

<b>Signature</b>

```typescript
componentDidUpdate(prevProps: QueryFieldProps, prevState: QueryFieldState): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  prevProps | <code>QueryFieldProps</code> |  |
|  prevState | <code>QueryFieldState</code> |  |

<b>Returns:</b>

`void`

### componentWillUnmount method

<b>Signature</b>

```typescript
componentWillUnmount(): void;
```
<b>Returns:</b>

`void`

### render method

<b>Signature</b>

```typescript
render(): JSX.Element;
```
<b>Returns:</b>

`JSX.Element`

