+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "FieldConfigEditorConfig"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## FieldConfigEditorConfig interface

<b>Signature</b>

```typescript
export interface FieldConfigEditorConfig<TOptions, TSettings = any, TValue = any> 
```
<b>Import</b>

```typescript
import { FieldConfigEditorConfig } from '@grafana/data';
```
<b>Properties</b>

|  Property | Type | Description |
|  --- | --- | --- |
|  [category](#category-property) | <code>string[]</code> | Array of strings representing category of the field config property. First element in the array will make option render as collapsible section. |
|  [defaultValue](#defaultvalue-property) | <code>TValue</code> |  |
|  [description](#description-property) | <code>string</code> | Description of the field config property. Will be displayed in the UI as form element description. |
|  [name](#name-property) | <code>string</code> | Name of the field config property. Will be displayed in the UI as form element label. |
|  [path](#path-property) | <code>(keyof TOptions &amp; string) &#124; string</code> | Path of the field config property to control. |
|  [settings](#settings-property) | <code>TSettings</code> | Custom settings of the editor. |
|  [shouldApply](#shouldapply-property) | <code>(field: Field) =&gt; boolean</code> | Function that allows specifying whether or not this field config should apply to a given field. |
|  [showIf](#showif-property) | <code>(currentConfig: TOptions) =&gt; boolean</code> | Function that enables configuration of when field config property editor should be shown based on current panel field config. |

### category property

Array of strings representing category of the field config property. First element in the array will make option render as collapsible section.

<b>Signature</b>

```typescript
category?: string[];
```

### defaultValue property

<b>Signature</b>

```typescript
defaultValue?: TValue;
```

### description property

Description of the field config property. Will be displayed in the UI as form element description.

<b>Signature</b>

```typescript
description?: string;
```

### name property

Name of the field config property. Will be displayed in the UI as form element label.

<b>Signature</b>

```typescript
name: string;
```

### path property

Path of the field config property to control.

<b>Signature</b>

```typescript
path: (keyof TOptions & string) | string;
```

## Example

Given field config object of a type:

```ts
interface CustomFieldConfig {
  a: {
    b: string;
  }
}

```
path can be either 'a' or 'a.b'.

### settings property

Custom settings of the editor.

<b>Signature</b>

```typescript
settings?: TSettings;
```

### shouldApply property

Function that allows specifying whether or not this field config should apply to a given field.

<b>Signature</b>

```typescript
shouldApply?: (field: Field) => boolean;
```

### showIf property

Function that enables configuration of when field config property editor should be shown based on current panel field config.

<b>Signature</b>

```typescript
showIf?: (currentConfig: TOptions) => boolean;
```
