+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "DataSourceApi"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## DataSourceApi class

The main data source abstraction interface, represents an instance of a data source

Although this is a class, datasource implementations do not \*yet\* need to extend it. As such, we can not yet add functions with default implementations.

<b>Signature</b>

```typescript
export declare abstract class DataSourceApi<TQuery extends DataQuery = DataQuery, TOptions extends DataSourceJsonData = DataSourceJsonData> 
```
<b>Import</b>

```typescript
import { DataSourceApi } from '@grafana/data';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(instanceSettings)](#constructor-instancesettings) |  | Constructs a new instance of the <code>DataSourceApi</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [components](#components-property) |  | <code>DataSourcePluginComponents&lt;DataSourceApi&lt;TQuery, TOptions&gt;, TQuery, TOptions&gt;</code> | Set after constructor call, as the data source instance is the most common thing to pass around we attach the components to this instance for easy access |
|  [getLogRowContext](#getlogrowcontext-property) |  | <code>&lt;TContextQueryOptions extends {}&gt;(row: LogRowModel, options?: TContextQueryOptions) =&gt; Promise&lt;DataQueryResponse&gt;</code> | Retrieve context for a given log row |
|  [id](#id-property) |  | <code>number</code> | Set in constructor |
|  [init](#init-property) |  | <code>() =&gt; void</code> | Initializes a datasource after instantiation |
|  [interval](#interval-property) |  | <code>string</code> | min interval range |
|  [languageProvider](#languageprovider-property) |  | <code>any</code> | Used in explore |
|  [meta](#meta-property) |  | <code>DataSourcePluginMeta</code> | static information about the datasource |
|  [name](#name-property) |  | <code>string</code> | Set in constructor |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [annotationQuery(options)](#annotationquery-method) |  | Can be optionally implemented to allow datasource to be a source of annotations for dashboard. To be visible in the annotation editor <code>annotations</code> capability also needs to be enabled in plugin.json. |
|  [getHighlighterExpression(query)](#gethighlighterexpression-method) |  | Used in explore |
|  [getQueryDisplayText(query)](#getquerydisplaytext-method) |  | Convert a query to a simple text string |
|  [getQueryHints(query, results, rest)](#getqueryhints-method) |  | Get hints for query improvements |
|  [getTagKeys(options)](#gettagkeys-method) |  | Get tag keys for adhoc filters |
|  [getTagValues(options)](#gettagvalues-method) |  | Get tag values for adhoc filters |
|  [getVersion(optionalOptions)](#getversion-method) |  |  |
|  [importQueries(queries, originMeta)](#importqueries-method) |  | Imports queries from a different datasource |
|  [interpolateVariablesInQueries(queries, scopedVars)](#interpolatevariablesinqueries-method) |  |  |
|  [metricFindQuery(query, options)](#metricfindquery-method) |  | Variable query action. |
|  [modifyQuery(query, action)](#modifyquery-method) |  | Used in explore |
|  [query(request)](#query-method) |  | Query for data, and optionally stream results |
|  [showContextToggle(row)](#showcontexttoggle-method) |  |  |
|  [targetContainsTemplate(query)](#targetcontainstemplate-method) |  | Used by alerting to check if query contains template variables |
|  [testDatasource()](#testdatasource-method) |  | Test &amp; verify datasource settings &amp; connection details |

### constructor(instanceSettings)

Constructs a new instance of the `DataSourceApi` class

<b>Signature</b>

```typescript
constructor(instanceSettings: DataSourceInstanceSettings<TOptions>);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  instanceSettings | <code>DataSourceInstanceSettings&lt;TOptions&gt;</code> |  |

### components property

Set after constructor call, as the data source instance is the most common thing to pass around we attach the components to this instance for easy access

<b>Signature</b>

```typescript
components?: DataSourcePluginComponents<DataSourceApi<TQuery, TOptions>, TQuery, TOptions>;
```

### getLogRowContext property

Retrieve context for a given log row

<b>Signature</b>

```typescript
getLogRowContext?: <TContextQueryOptions extends {}>(row: LogRowModel, options?: TContextQueryOptions) => Promise<DataQueryResponse>;
```

### id property

Set in constructor

<b>Signature</b>

```typescript
readonly id: number;
```

### init property

Initializes a datasource after instantiation

<b>Signature</b>

```typescript
init?: () => void;
```

### interval property

min interval range

<b>Signature</b>

```typescript
interval?: string;
```

### languageProvider property

Used in explore

<b>Signature</b>

```typescript
languageProvider?: any;
```

### meta property

static information about the datasource

<b>Signature</b>

```typescript
meta: DataSourcePluginMeta;
```

### name property

Set in constructor

<b>Signature</b>

```typescript
readonly name: string;
```

### annotationQuery method

Can be optionally implemented to allow datasource to be a source of annotations for dashboard. To be visible in the annotation editor `annotations` capability also needs to be enabled in plugin.json.

<b>Signature</b>

```typescript
annotationQuery?(options: AnnotationQueryRequest<TQuery>): Promise<AnnotationEvent[]>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | <code>AnnotationQueryRequest&lt;TQuery&gt;</code> |  |

<b>Returns:</b>

`Promise<AnnotationEvent[]>`

### getHighlighterExpression method

Used in explore

<b>Signature</b>

```typescript
getHighlighterExpression?(query: TQuery): string[];
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>TQuery</code> |  |

<b>Returns:</b>

`string[]`

### getQueryDisplayText method

Convert a query to a simple text string

<b>Signature</b>

```typescript
getQueryDisplayText?(query: TQuery): string;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>TQuery</code> |  |

<b>Returns:</b>

`string`

### getQueryHints method

Get hints for query improvements

<b>Signature</b>

```typescript
getQueryHints?(query: TQuery, results: any[], ...rest: any): QueryHint[];
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>TQuery</code> |  |
|  results | <code>any[]</code> |  |
|  rest | <code>any</code> |  |

<b>Returns:</b>

`QueryHint[]`

### getTagKeys method

Get tag keys for adhoc filters

<b>Signature</b>

```typescript
getTagKeys?(options?: any): Promise<MetricFindValue[]>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | <code>any</code> |  |

<b>Returns:</b>

`Promise<MetricFindValue[]>`

### getTagValues method

Get tag values for adhoc filters

<b>Signature</b>

```typescript
getTagValues?(options: any): Promise<MetricFindValue[]>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | <code>any</code> |  |

<b>Returns:</b>

`Promise<MetricFindValue[]>`

### getVersion method

<b>Signature</b>

```typescript
getVersion?(optionalOptions?: any): Promise<string>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  optionalOptions | <code>any</code> |  |

<b>Returns:</b>

`Promise<string>`

### importQueries method

Imports queries from a different datasource

<b>Signature</b>

```typescript
importQueries?(queries: TQuery[], originMeta: PluginMeta): Promise<TQuery[]>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  queries | <code>TQuery[]</code> |  |
|  originMeta | <code>PluginMeta</code> |  |

<b>Returns:</b>

`Promise<TQuery[]>`

### interpolateVariablesInQueries method

<b>Signature</b>

```typescript
interpolateVariablesInQueries?(queries: TQuery[], scopedVars: ScopedVars | {}): TQuery[];
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  queries | <code>TQuery[]</code> |  |
|  scopedVars | <code>ScopedVars &#124; {}</code> |  |

<b>Returns:</b>

`TQuery[]`

### metricFindQuery method

Variable query action.

<b>Signature</b>

```typescript
metricFindQuery?(query: any, options?: any): Promise<MetricFindValue[]>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>any</code> |  |
|  options | <code>any</code> |  |

<b>Returns:</b>

`Promise<MetricFindValue[]>`

### modifyQuery method

Used in explore

<b>Signature</b>

```typescript
modifyQuery?(query: TQuery, action: QueryFixAction): TQuery;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>TQuery</code> |  |
|  action | <code>QueryFixAction</code> |  |

<b>Returns:</b>

`TQuery`

### query method

Query for data, and optionally stream results

<b>Signature</b>

```typescript
abstract query(request: DataQueryRequest<TQuery>): Promise<DataQueryResponse> | Observable<DataQueryResponse>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | <code>DataQueryRequest&lt;TQuery&gt;</code> |  |

<b>Returns:</b>

`Promise<DataQueryResponse> | Observable<DataQueryResponse>`

### showContextToggle method

<b>Signature</b>

```typescript
showContextToggle?(row?: LogRowModel): boolean;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  row | <code>LogRowModel</code> |  |

<b>Returns:</b>

`boolean`

### targetContainsTemplate method

Used by alerting to check if query contains template variables

<b>Signature</b>

```typescript
targetContainsTemplate?(query: TQuery): boolean;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | <code>TQuery</code> |  |

<b>Returns:</b>

`boolean`

### testDatasource method

Test &amp; verify datasource settings &amp; connection details

<b>Signature</b>

```typescript
abstract testDatasource(): Promise<any>;
```
<b>Returns:</b>

`Promise<any>`

