+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "EchoSrv"
keywords = ["grafana","documentation","sdk","@grafana/runtime"]
type = "docs"
+++

## EchoSrv interface

Used to send events to all the registered backends. This should be accessed via the [getEchoSrv()](./runtime/getechosrv.md) function. Will, by default, flush events to the backends every 10s or when the flush function is triggered.

<b>Signature</b>

```typescript
export interface EchoSrv 
```
<b>Import</b>

```typescript
import { EchoSrv } from '@grafana/runtime';
```
<b>Methods</b>

|  Method | Description |
|  --- | --- |
|  [addBackend(backend)](#addbackend-method) | Add a new echo backend to the list of backends that will receive events. |
|  [addEvent(event, meta)](#addevent-method) | Call this to add event that will be sent to the echo backends upon next flush. |
|  [flush()](#flush-method) | Call this to flush current events to the echo backends. |

### addBackend method

Add a new echo backend to the list of backends that will receive events.

<b>Signature</b>

```typescript
addBackend(backend: EchoBackend): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  backend | <code>EchoBackend</code> |  |

<b>Returns:</b>

`void`

### addEvent method

Call this to add event that will be sent to the echo backends upon next flush.

<b>Signature</b>

```typescript
addEvent<T extends EchoEvent>(event: Omit<T, 'meta'>, meta?: {}): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  event | <code>Omit&lt;T, 'meta'&gt;</code> | Object containing event information. |
|  meta | <code>{}</code> | Object that will extend/override the default meta object. |

<b>Returns:</b>

`void`

### flush method

Call this to flush current events to the echo backends.

<b>Signature</b>

```typescript
flush(): void;
```
<b>Returns:</b>

`void`

