+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "CircularVector"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## CircularVector class

Circular vector uses a single buffer to capture a stream of values overwriting the oldest value on add.

This supports addting to the 'head' or 'tail' and will grow the buffer to match a configured capacity.

<b>Signature</b>

```typescript
export declare class CircularVector<T = any> extends FunctionalVector implements MutableVector<T> 
```
<b>Import</b>

```typescript
import { CircularVector } from '@grafana/data';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(options)](#constructor-options) |  | Constructs a new instance of the <code>CircularVector</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [add](#add-property) |  | <code>(value: T) =&gt; void</code> | Add the value to the buffer |
|  [length](#length-property) |  | <code>number</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [get(index)](#get-method) |  |  |
|  [reverse()](#reverse-method) |  |  |
|  [set(index, value)](#set-method) |  |  |
|  [setAppendMode(mode)](#setappendmode-method) |  |  |
|  [setCapacity(v)](#setcapacity-method) |  |  |
|  [toArray()](#toarray-method) |  |  |
|  [toJSON()](#tojson-method) |  |  |

### constructor(options)

Constructs a new instance of the `CircularVector` class

<b>Signature</b>

```typescript
constructor(options: CircularOptions<T>);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | <code>CircularOptions&lt;T&gt;</code> |  |

### add property

Add the value to the buffer

<b>Signature</b>

```typescript
add: (value: T) => void;
```

### length property

<b>Signature</b>

```typescript
get length(): number;
```

### get method

<b>Signature</b>

```typescript
get(index: number): T;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  index | <code>number</code> |  |

<b>Returns:</b>

`T`

### reverse method

<b>Signature</b>

```typescript
reverse(): void;
```
<b>Returns:</b>

`void`

### set method

<b>Signature</b>

```typescript
set(index: number, value: T): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  index | <code>number</code> |  |
|  value | <code>T</code> |  |

<b>Returns:</b>

`void`

### setAppendMode method

<b>Signature</b>

```typescript
setAppendMode(mode: 'head' | 'tail'): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  mode | <code>'head' &#124; 'tail'</code> |  |

<b>Returns:</b>

`void`

### setCapacity method

<b>Signature</b>

```typescript
setCapacity(v: number): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  v | <code>number</code> |  |

<b>Returns:</b>

`void`

### toArray method

<b>Signature</b>

```typescript
toArray(): T[];
```
<b>Returns:</b>

`T[]`

### toJSON method

<b>Signature</b>

```typescript
toJSON(): T[];
```
<b>Returns:</b>

`T[]`

