/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SerializableTestResult {
    private final String name;
    private final String displayName;
    private final TestResult.ResultType resultType;
    private final long startTime;
    private final long endTime;
    private final ImmutableList<SerializableFailure> failures;
    private final ImmutableList<SerializedMetadata> metadatas;

    public static Builder builder() {
        return new Builder();
    }

    public SerializableTestResult(String name, String displayName, TestResult.ResultType resultType, long startTime, long endTime, ImmutableList<SerializableFailure> failures, ImmutableList<SerializedMetadata> metadatas) {
        this.name = name;
        this.displayName = displayName;
        this.resultType = resultType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.failures = failures;
        this.metadatas = metadatas;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public ImmutableList<SerializableFailure> getFailures() {
        return this.failures;
    }

    public ImmutableList<SerializedMetadata> getMetadatas() {
        return this.metadatas;
    }

    @NullMarked
    public static final class Builder {
        private String name;
        private String displayName;
        private TestResult.ResultType resultType;
        private Long startTime;
        private Long endTime;
        private final ImmutableList.Builder<SerializableFailure> failures = ImmutableList.builder();
        private final ImmutableList.Builder<SerializedMetadata> metadatas = ImmutableList.builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder resultType(TestResult.ResultType resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder addFailure(SerializableFailure failure) {
            this.failures.add((Object)failure);
            return this;
        }

        public Builder addMetadata(SerializedMetadata metadata) {
            this.metadatas.add((Object)metadata);
            return this;
        }

        public SerializableTestResult build() {
            if (this.name == null) {
                throw new IllegalStateException("name is required");
            }
            if (this.displayName == null) {
                throw new IllegalStateException("displayName is required");
            }
            if (this.resultType == null) {
                throw new IllegalStateException("resultType is required");
            }
            if (this.startTime == null) {
                throw new IllegalStateException("startTime is required");
            }
            if (this.endTime == null) {
                throw new IllegalStateException("endTime is required");
            }
            return new SerializableTestResult(this.name, this.displayName, this.resultType, this.startTime, this.endTime, (ImmutableList<SerializableFailure>)this.failures.build(), (ImmutableList<SerializedMetadata>)this.metadatas.build());
        }
    }

    @NullMarked
    public static final class Serializer {
        private Serializer() {
        }

        public static void serialize(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeString((CharSequence)result.name);
            encoder.writeString((CharSequence)result.displayName);
            encoder.writeSmallInt(result.resultType.ordinal());
            encoder.writeLong(result.startTime);
            encoder.writeLong(result.endTime);
            Serializer.serializeFailures(result, encoder);
            Serializer.serializeMetadatas(result, encoder);
        }

        public static SerializableTestResult deserialize(Decoder decoder) throws IOException {
            String name = decoder.readString();
            String displayName = decoder.readString();
            TestResult.ResultType resultType = TestResult.ResultType.values()[decoder.readSmallInt()];
            long startTime = decoder.readLong();
            long endTime = decoder.readLong();
            ImmutableList<SerializableFailure> failures = Serializer.deserializeFailures(decoder);
            ImmutableList<SerializedMetadata> metadatas = Serializer.deserializeMetadatas(decoder);
            return new SerializableTestResult(name, displayName, resultType, startTime, endTime, failures, metadatas);
        }

        private static void serializeFailures(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeSmallInt(result.failures.size());
            for (SerializableFailure failure : result.failures) {
                encoder.writeString((CharSequence)failure.getMessage());
                encoder.writeString((CharSequence)failure.getStackTrace());
                encoder.writeString((CharSequence)failure.getExceptionType());
            }
        }

        private static ImmutableList<SerializableFailure> deserializeFailures(Decoder decoder) throws IOException {
            ImmutableList.Builder failures = ImmutableList.builder();
            int failureCount = decoder.readSmallInt();
            for (int i = 0; i < failureCount; ++i) {
                String message = decoder.readString();
                String stackTrace = decoder.readString();
                String exceptionType = decoder.readString();
                failures.add((Object)new SerializableFailure(message, stackTrace, exceptionType));
            }
            return failures.build();
        }

        private static void serializeMetadatas(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeSmallInt(result.metadatas.size());
            for (SerializedMetadata metadata : result.metadatas) {
                encoder.writeLong(metadata.getLogTime());
                encoder.writeSmallInt(metadata.getEntries().size());
                for (SerializedMetadata.SerializedMetadataElement entry : metadata.getEntries()) {
                    encoder.writeString((CharSequence)entry.getKey());
                    encoder.writeBinary(entry.getSerializedValue());
                    encoder.writeString((CharSequence)entry.getValueType());
                }
            }
        }

        private static ImmutableList<SerializedMetadata> deserializeMetadatas(Decoder decoder) throws IOException {
            ImmutableList.Builder metadatas = ImmutableList.builder();
            int metadataCount = decoder.readSmallInt();
            for (int i = 0; i < metadataCount; ++i) {
                long logTime = decoder.readLong();
                int entryCount = decoder.readSmallInt();
                ImmutableList.Builder entries = ImmutableList.builder();
                for (int j = 0; j < entryCount; ++j) {
                    String key = decoder.readString();
                    byte[] value = decoder.readBinary();
                    String valueType = decoder.readString();
                    entries.add((Object)new SerializedMetadata.SerializedMetadataElement(key, value, valueType));
                }
                metadatas.add((Object)new SerializedMetadata(logTime, (ImmutableList<SerializedMetadata.SerializedMetadataElement>)entries.build()));
            }
            return metadatas.build();
        }
    }
}

