/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.encryption.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.function.Consumer;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.encryption.impl.LoggerKt;
import org.gradle.internal.encryption.impl.SecretKeySource;
import org.gradle.internal.file.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\"H\u0016J\f\u0010#\u001a\u00020\u0005*\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000e\u00a8\u0006,"}, d2={"Lorg/gradle/internal/encryption/impl/KeyStoreKeySource;", "Lorg/gradle/internal/encryption/impl/SecretKeySource;", "encryptionAlgorithm", "", "customKeyStoreDir", "Ljava/io/File;", "keyAlias", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "fileSystem", "Lorg/gradle/internal/file/FileSystem;", "<init>", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;Lorg/gradle/internal/file/FileSystem;)V", "getEncryptionAlgorithm", "()Ljava/lang/String;", "getCustomKeyStoreDir", "()Ljava/io/File;", "getKeyAlias", "getCacheBuilderFactory", "()Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "getFileSystem", "()Lorg/gradle/internal/file/FileSystem;", "keyProtection", "Ljava/security/KeyStore$PasswordProtection;", "keyStore", "Ljava/security/KeyStore;", "kotlin.jvm.PlatformType", "getKeyStore", "()Ljava/security/KeyStore;", "keyStore$delegate", "Lkotlin/Lazy;", "sourceDescription", "getSourceDescription", "createKeyStoreAndGenerateKey", "Ljavax/crypto/SecretKey;", "keyStoreFile", "loadSecretKeyFromExistingKeystore", "generateKey", "alias", "cacheBuilderFor", "Lorg/gradle/cache/CacheBuilder;", "getKey", "Lorg/gradle/cache/PersistentCache;", "Companion", "encryption-services"})
@SourceDebugExtension(value={"SMAP\nKeyStoreKeySource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStoreKeySource.kt\norg/gradle/internal/encryption/impl/KeyStoreKeySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AutoCloseableExtensions.kt\norg/gradle/internal/extensions/stdlib/AutoCloseableExtensionsKt\n*L\n1#1,133:1\n1#2:134\n1#2:136\n21#3:135\n*S KotlinDebug\n*F\n+ 1 KeyStoreKeySource.kt\norg/gradle/internal/encryption/impl/KeyStoreKeySource\n*L\n105#1:136\n105#1:135\n*E\n"})
public final class KeyStoreKeySource
implements SecretKeySource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String encryptionAlgorithm;
    @Nullable
    private final File customKeyStoreDir;
    @NotNull
    private final String keyAlias;
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final KeyStore.PasswordProtection keyProtection;
    @NotNull
    private final Lazy keyStore$delegate;
    @NotNull
    public static final String KEYSTORE_TYPE = "pkcs12";
    @NotNull
    private static final char[] KEYSTORE_PASSWORD;
    private static final int KEYSTORE_FILE_PERMISSIONS;

    public KeyStoreKeySource(@NotNull String encryptionAlgorithm, @Nullable File customKeyStoreDir, @NotNull String keyAlias, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.customKeyStoreDir = customKeyStoreDir;
        this.keyAlias = keyAlias;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.fileSystem = fileSystem;
        this.keyProtection = new KeyStore.PasswordProtection(new char[0]);
        this.keyStore$delegate = LazyKt.lazy(KeyStoreKeySource::keyStore_delegate$lambda$0);
    }

    @NotNull
    public final String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Nullable
    public final File getCustomKeyStoreDir() {
        return this.customKeyStoreDir;
    }

    @NotNull
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    @NotNull
    public final GlobalScopedCacheBuilderFactory getCacheBuilderFactory() {
        return this.cacheBuilderFactory;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private final KeyStore getKeyStore() {
        Lazy lazy = this.keyStore$delegate;
        return (KeyStore)lazy.getValue();
    }

    @Override
    @NotNull
    public String getSourceDescription() {
        Object object;
        block3: {
            block2: {
                object = this.customKeyStoreDir;
                if (object == null) break block2;
                File it = object;
                boolean bl = false;
                String string = "custom Java keystore at " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "default Gradle configuration cache keystore";
        }
        return object;
    }

    private final SecretKey createKeyStoreAndGenerateKey(File keyStoreFile) {
        SecretKey secretKey;
        LoggerKt.getLogger().debug("No keystore found");
        this.getKeyStore().load(null, KEYSTORE_PASSWORD);
        SecretKey it = secretKey = this.generateKey(keyStoreFile, this.keyAlias);
        boolean bl = false;
        LoggerKt.getLogger().debug("Key added to a new keystore at {}", (Object)keyStoreFile);
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey loadSecretKeyFromExistingKeystore(File keyStoreFile) {
        Object fis;
        LoggerKt.getLogger().debug("Loading keystore from {}", (Object)keyStoreFile);
        Closeable closeable = new FileInputStream(keyStoreFile);
        Serializable serializable = null;
        try {
            fis = (FileInputStream)closeable;
            boolean bl = false;
            this.getKeyStore().load((InputStream)fis, KEYSTORE_PASSWORD);
            fis = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            serializable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
        }
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.getKeyStore().getEntry(this.keyAlias, this.keyProtection);
        if (entry != null) {
            Object it = fis = entry.getSecretKey();
            boolean bl = false;
            LoggerKt.getLogger().debug("Retrieved key");
            Object object = fis;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"also(...)");
            return object;
        }
        LoggerKt.getLogger().debug("No key found");
        Serializable it = serializable = this.generateKey(keyStoreFile, this.keyAlias);
        boolean bl = false;
        LoggerKt.getLogger().warn("Key added to existing keystore at {}", (Object)keyStoreFile);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey generateKey(File keyStoreFile, String alias) {
        SecretKey newKey = KeyGenerator.getInstance(this.encryptionAlgorithm).generateKey();
        if (!(newKey != null)) {
            boolean bl = false;
            String string = "Failed to generate encryption key using " + this.encryptionAlgorithm + '.';
            throw new IllegalArgumentException(string.toString());
        }
        LoggerKt.getLogger().debug("Generated key");
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(newKey);
        this.getKeyStore().setEntry(alias, entry, this.keyProtection);
        Closeable closeable = new FileOutputStream(keyStoreFile);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            this.fileSystem.chmod(keyStoreFile, KEYSTORE_FILE_PERMISSIONS);
            this.getKeyStore().store(fos, KEYSTORE_PASSWORD);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return newKey;
    }

    /*
     * WARNING - void declaration
     */
    private final CacheBuilder cacheBuilderFor() {
        File file;
        block3: {
            void var1_1;
            block2: {
                GlobalScopedCacheBuilderFactory $this$cacheBuilderFor_u24lambda_u249 = this.cacheBuilderFactory;
                boolean bl = false;
                file = this.customKeyStoreDir;
                if (file == null) break block2;
                File it = file;
                boolean bl2 = false;
                GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory = $this$cacheBuilderFor_u24lambda_u249.createCacheBuilderFactory(it);
                file = globalScopedCacheBuilderFactory;
                if (globalScopedCacheBuilderFactory != null) break block3;
            }
            file = var1_1;
        }
        CacheBuilder cacheBuilder = file.createCacheBuilder("cc-keystore").withDisplayName("Gradle Configuration Cache keystore");
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withDisplayName(...)");
        return cacheBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SecretKey getKey() {
        SecretKey secretKey;
        AutoCloseable $this$useToRun$iv = (AutoCloseable)this.cacheBuilderFor().withInitializer(new Consumer(this){
            final /* synthetic */ KeyStoreKeySource this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(PersistentCache it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KeyStoreKeySource.access$createKeyStoreAndGenerateKey(this.this$0, KeyStoreKeySource.access$keyStoreFile(this.this$0, it));
            }
        }).open();
        boolean $i$f$useToRun = false;
        AutoCloseable autoCloseable = $this$useToRun$iv;
        Throwable throwable = null;
        try {
            SecretKey secretKey2;
            AutoCloseable it$iv = autoCloseable;
            boolean bl = false;
            PersistentCache $this$getKey_u24lambda_u2410 = (PersistentCache)$this$useToRun$iv;
            boolean bl2 = false;
            try {
                Intrinsics.checkNotNull((Object)$this$getKey_u24lambda_u2410);
                secretKey2 = this.loadSecretKeyFromExistingKeystore(this.keyStoreFile($this$getKey_u24lambda_u2410));
            }
            catch (Exception loadException) {
                SecretKey secretKey3;
                try {
                    Intrinsics.checkNotNull((Object)$this$getKey_u24lambda_u2410);
                    secretKey3 = this.createKeyStoreAndGenerateKey(this.keyStoreFile($this$getKey_u24lambda_u2410));
                }
                catch (Exception e) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)loadException);
                    throw e;
                }
                secretKey2 = secretKey3;
            }
            secretKey = secretKey2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return secretKey;
    }

    private final File keyStoreFile(PersistentCache $this$keyStoreFile) {
        return new File($this$keyStoreFile.getBaseDir(), "gradle.keystore");
    }

    private static final KeyStore keyStore_delegate$lambda$0() {
        return KeyStore.getInstance(KEYSTORE_TYPE);
    }

    public static final /* synthetic */ SecretKey access$createKeyStoreAndGenerateKey(KeyStoreKeySource $this, File keyStoreFile) {
        return $this.createKeyStoreAndGenerateKey(keyStoreFile);
    }

    public static final /* synthetic */ File access$keyStoreFile(KeyStoreKeySource $this, PersistentCache $receiver) {
        return $this.keyStoreFile($receiver);
    }

    static {
        char[] cArray = new char[]{'c', 'c'};
        KEYSTORE_PASSWORD = cArray;
        KEYSTORE_FILE_PERMISSIONS = Integer.parseInt("0600", CharsKt.checkRadix((int)8));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gradle/internal/encryption/impl/KeyStoreKeySource$Companion;", "", "<init>", "()V", "KEYSTORE_TYPE", "", "KEYSTORE_PASSWORD", "", "KEYSTORE_FILE_PERMISSIONS", "", "encryption-services"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

