/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public final class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final ChildInfo[] myChildren;
    private final int myChildNameId;
    private VirtualFile myCreatedFile;

    @NotNull
    public String getChildName() {
        String string = VirtualFileManager.getInstance().getVFileName(this.myChildNameId).toString();
        if (string == null) {
            VFileCreateEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile = this.myParent;
        if (virtualFile == null) {
            VFileCreateEvent.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myChildren != null && this.myChildren.length == 0;
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null && this.myParent.isValid()) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.getChildName());
        }
        return createdFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCreateEvent.$$$reportNull$$$0(7);
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o2;
        return this.myDirectory == event.myDirectory && this.getChildName().equals(event.getChildName()) && this.myParent.equals(event.myParent);
    }

    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.getChildName().hashCode();
        return result2;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + "'" + this.myParent.getUrl() + "/" + this.getChildName() + "']" + (this.myChildren == null ? "" : " with " + this.myChildren.length + " children");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

