/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.util.Set;
import javax.crypto.SecretKey;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.cc.impl.DefaultEncryptionService;
import org.gradle.internal.cc.impl.EncryptionKind;
import org.gradle.internal.cc.impl.EncryptionService;
import org.gradle.internal.cc.impl.EnvironmentVarKeySource;
import org.gradle.internal.cc.impl.KeyStoreKeySource;
import org.gradle.internal.cc.impl.NoEncryptionKeySource;
import org.gradle.internal.cc.impl.SecretKeySource;
import org.gradle.internal.cc.impl.StateType;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.EncryptionAlgorithm;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0016J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\"H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020(H\u0002JC\u0010)\u001a\u0002H*\"\b\b\u0000\u0010+*\u00020,\"\b\b\u0001\u0010**\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0\"2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u0002H*0/H\u0002\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gradle/internal/cc/impl/DefaultEncryptionService;", "Lorg/gradle/internal/cc/impl/EncryptionService;", "startParameter", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "(Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;)V", "encryptionAlgorithm", "Lorg/gradle/util/internal/EncryptionAlgorithm;", "getEncryptionAlgorithm", "()Lorg/gradle/util/internal/EncryptionAlgorithm;", "encryptionAlgorithm$delegate", "Lkotlin/Lazy;", "encryptionKeyHashCode", "Lorg/gradle/internal/hash/HashCode;", "getEncryptionKeyHashCode", "()Lorg/gradle/internal/hash/HashCode;", "encryptionKeyHashCode$delegate", "isEncrypting", "", "()Z", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "assertKeyLength", "", "key", "inputStream", "Ljava/io/InputStream;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "input", "Lkotlin/Function0;", "outputStream", "Ljava/io/OutputStream;", "output", "produceSecretKey", "encryptionKind", "Lorg/gradle/internal/cc/impl/EncryptionKind;", "safeWrap", "T", "C", "Ljava/io/Closeable;", "innerSupplier", "unsafeWrapper", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/io/Closeable;", "secretKeyFrom", "keySource", "Lorg/gradle/internal/cc/impl/SecretKeySource;", "secretKeySource", "kind", "shouldEncryptStreams", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionService.kt\norg/gradle/internal/cc/impl/DefaultEncryptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1#2:353\n*E\n"})
public final class DefaultEncryptionService
implements EncryptionService {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    private final Lazy encryptionAlgorithm$delegate;
    @NotNull
    private final Lazy encryptionKeyHashCode$delegate;

    public DefaultEncryptionService(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        this.startParameter = startParameter;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.secretKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecretKey>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SecretKey invoke() {
                return DefaultEncryptionService.access$produceSecretKey(this.this$0, EncryptionKind.Companion.select(DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionRequested()));
            }
        }));
        this.encryptionAlgorithm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EncryptionAlgorithm>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EncryptionAlgorithm invoke() {
                Object v1;
                block2: {
                    Set set = SupportedEncryptionAlgorithm.getAll();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll()");
                    Iterable iterable = set;
                    DefaultEncryptionService defaultEncryptionService = this.this$0;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        EncryptionAlgorithm it = (EncryptionAlgorithm)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getTransformation(), (Object)DefaultEncryptionService.access$getStartParameter$p(defaultEncryptionService).getEncryptionAlgorithm())) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                EncryptionAlgorithm encryptionAlgorithm2 = v1;
                if (encryptionAlgorithm2 == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported encryption algorithm: ").append(DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionAlgorithm()).append(". Supported algorithms are: ");
                    Set set = SupportedEncryptionAlgorithm.getAll();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll()");
                    throw new InvalidUserDataException(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)encryptionAlgorithm.2.INSTANCE, (int)31, null)).toString());
                }
                return encryptionAlgorithm2;
            }
        }));
        this.encryptionKeyHashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashCode>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HashCode invoke() {
                SecretKey secretKey2;
                block3: {
                    block2: {
                        Hasher hasher;
                        secretKey2 = DefaultEncryptionService.access$getSecretKey(this.this$0);
                        if (secretKey2 == null) break block2;
                        SecretKey secretKey3 = secretKey2;
                        DefaultEncryptionService defaultEncryptionService = this.this$0;
                        SecretKey it = secretKey3;
                        boolean bl = false;
                        Hasher $this$invoke_u24lambda_u241_u24lambda_u240 = hasher = Hashing.sha512().newHasher();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.putBytes(it.getEncoded());
                        $this$invoke_u24lambda_u241_u24lambda_u240.putString((CharSequence)defaultEncryptionService.getEncryptionAlgorithm().getTransformation());
                        HashCode hashCode = hasher.hash();
                        secretKey2 = hashCode;
                        if (hashCode != null) break block3;
                    }
                    secretKey2 = Hashing.newHasher().hash();
                }
                Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"secretKey?.let {\n       \u2026ashing.newHasher().hash()");
                return secretKey2;
            }
        }));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final SecretKey produceSecretKey(EncryptionKind encryptionKind) {
        SecretKey secretKey2;
        SecretKeySource keySource = this.secretKeySource(encryptionKind);
        boolean bl = false;
        try {
            SecretKey secretKey3;
            SecretKey secretKey4 = this.secretKeyFrom(keySource);
            if (secretKey4 != null) {
                SecretKey secretKey5;
                SecretKey key = secretKey5 = secretKey4;
                boolean bl2 = false;
                this.assertKeyLength(key);
                secretKey3 = secretKey5;
            } else {
                secretKey3 = null;
            }
            secretKey2 = secretKey3;
        }
        catch (Exception e) {
            throw new GradleException("Error loading encryption key from " + keySource.getSourceDescription(), (Throwable)e);
        }
        return secretKey2;
    }

    private final SecretKey secretKeyFrom(SecretKeySource keySource) {
        return keySource.getKey();
    }

    private final void assertKeyLength(SecretKey key) {
        int keyLength = key.getEncoded().length;
        if (keyLength < 16) {
            throw new InvalidKeyException("Encryption key length is " + keyLength + " bytes, but must be at least 16 bytes long");
        }
    }

    @Override
    @NotNull
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        Lazy lazy = this.encryptionAlgorithm$delegate;
        return (EncryptionAlgorithm)lazy.getValue();
    }

    @Override
    public boolean isEncrypting() {
        return this.getSecretKey() != null;
    }

    @Override
    @NotNull
    public HashCode getEncryptionKeyHashCode() {
        Lazy lazy = this.encryptionKeyHashCode$delegate;
        return (HashCode)lazy.getValue();
    }

    private final boolean shouldEncryptStreams(StateType stateType) {
        return this.isEncrypting() && stateType.getEncryptable();
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull StateType stateType, @NotNull Function0<? extends OutputStream> output) {
        OutputStream outputStream2;
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        if (this.shouldEncryptStreams(stateType)) {
            Object t = this.safeWrap(output, (Function1)new Function1<OutputStream, OutputStream>(this){
                final /* synthetic */ DefaultEncryptionService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final OutputStream invoke(@NotNull OutputStream it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getEncryptionAlgorithm().encryptedStream(it, DefaultEncryptionService.access$getSecretKey(this.this$0));
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"override fun outputStrea\u2026          output.invoke()");
            outputStream2 = (OutputStream)t;
        } else {
            outputStream2 = (OutputStream)output.invoke();
        }
        return outputStream2;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull StateType stateType, @NotNull Function0<? extends InputStream> input) {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (this.shouldEncryptStreams(stateType)) {
            Object t = this.safeWrap(input, (Function1)new Function1<InputStream, InputStream>(this){
                final /* synthetic */ DefaultEncryptionService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final InputStream invoke(@NotNull InputStream it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getEncryptionAlgorithm().decryptedStream(it, DefaultEncryptionService.access$getSecretKey(this.this$0));
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"override fun inputStream\u2026           input.invoke()");
            inputStream2 = (InputStream)t;
        } else {
            inputStream2 = (InputStream)input.invoke();
        }
        return inputStream2;
    }

    private final <C extends Closeable, T extends Closeable> T safeWrap(Function0<? extends C> innerSupplier, Function1<? super C, ? extends T> unsafeWrapper) {
        Closeable closeable;
        Closeable innerCloseable = (Closeable)innerSupplier.invoke();
        try {
            closeable = (Closeable)unsafeWrapper.invoke((Object)innerCloseable);
        }
        catch (Throwable e) {
            try {
                innerCloseable.close();
            }
            catch (Throwable closingException) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closingException);
            }
            throw e;
        }
        Closeable outerCloseable = closeable;
        return (T)outerCloseable;
    }

    /*
     * WARNING - void declaration
     */
    private final SecretKeySource secretKeySource(EncryptionKind kind) {
        SecretKeySource secretKeySource;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                File file;
                String string2 = this.getEncryptionAlgorithm().getAlgorithm();
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encryptionAlgorithm.algorithm");
                String string4 = this.startParameter.getKeystoreDir();
                if (string4 != null) {
                    void it;
                    String string5 = string4;
                    String string6 = string3;
                    boolean bl = false;
                    file = new File((String)it);
                    string3 = string6;
                } else {
                    file = null;
                }
                GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory = this.cacheBuilderFactory;
                String string7 = "gradle-secret";
                File file2 = file;
                String string8 = string3;
                secretKeySource = new KeyStoreKeySource(string8, file2, string7, globalScopedCacheBuilderFactory);
                break;
            }
            case 2: {
                String string9 = this.getEncryptionAlgorithm().getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"encryptionAlgorithm.algorithm");
                secretKeySource = new EnvironmentVarKeySource(string9);
                break;
            }
            case 3: {
                secretKeySource = new NoEncryptionKeySource();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return secretKeySource;
    }

    public static final /* synthetic */ SecretKey access$getSecretKey(DefaultEncryptionService $this) {
        return $this.getSecretKey();
    }

    public static final /* synthetic */ SecretKey access$produceSecretKey(DefaultEncryptionService $this, EncryptionKind encryptionKind) {
        return $this.produceSecretKey(encryptionKind);
    }

    public static final /* synthetic */ ConfigurationCacheStartParameter access$getStartParameter$p(DefaultEncryptionService $this) {
        return $this.startParameter;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionKind.values().length];
            try {
                nArray[EncryptionKind.KEYSTORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.ENV_VAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

