/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorFactoryProvider;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorFactorySet;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorSet;
import org.gradle.internal.instrumentation.api.jvmbytecode.JvmBytecodeCallInterceptor;
import org.gradle.internal.instrumentation.api.metadata.InstrumentationMetadata;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.objectweb.asm.MethodVisitor;

public class DefaultJvmBytecodeInterceptorFactorySet
implements JvmBytecodeInterceptorFactorySet {
    private final JvmBytecodeInterceptorFactoryProvider provider;

    public DefaultJvmBytecodeInterceptorFactorySet(JvmBytecodeInterceptorFactoryProvider provider) {
        this.provider = provider;
    }

    @Override
    public JvmBytecodeInterceptorSet getJvmBytecodeInterceptorSet(final BytecodeInterceptorFilter filter) {
        final List factories = this.provider.getInterceptorFactories().stream().filter(arg_0 -> ((BytecodeInterceptorFilter)filter).matches(arg_0)).collect(Collectors.toList());
        return new JvmBytecodeInterceptorSet(){

            @Override
            public List<JvmBytecodeCallInterceptor> getInterceptors(MethodVisitor methodVisitor, ClassData classData) {
                return factories.stream().map(factory -> factory.create(methodVisitor, (InstrumentationMetadata)classData, filter)).collect(Collectors.toList());
            }

            @Override
            public BytecodeInterceptorFilter getOriginalFilter() {
                return filter;
            }
        };
    }
}

