/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.TimestampSuppliers;

@ServiceScope(value={Scopes.BuildSession.class})
public class ProjectCacheDir
implements Stoppable {
    private static final int MAX_UNUSED_DAYS_FOR_RELEASES_AND_SNAPSHOTS = 7;
    private final File dir;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final Deleter deleter;

    public ProjectCacheDir(File dir, ProgressLoggerFactory progressLoggerFactory, Deleter deleter) {
        this.dir = dir;
        this.progressLoggerFactory = progressLoggerFactory;
        this.deleter = deleter;
    }

    public File getDir() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        VersionSpecificCacheCleanupAction cleanupAction = new VersionSpecificCacheCleanupAction(this.dir, TimestampSuppliers.daysAgo((int)7), this.deleter, CleanupFrequency.DAILY);
        String description = cleanupAction.getDisplayName();
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(ProjectCacheDir.class).start(description, description);
        try {
            cleanupAction.execute((CleanupProgressMonitor)new DefaultCleanupProgressMonitor(progressLogger));
        }
        finally {
            progressLogger.completed();
        }
    }
}

