/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.util.concurrent.Striped;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.gradle.internal.UncheckedException;

public abstract class ProducerGuard<T> {
    public static <T> ProducerGuard<T> adaptive() {
        return new AdaptiveProducerGuard();
    }

    public static <T> ProducerGuard<T> striped() {
        return new StripedProducerGuard();
    }

    public static <T> ProducerGuard<T> serial() {
        return new SerialProducerGuard();
    }

    private ProducerGuard() {
    }

    public abstract <V> V guardByKey(T var1, Supplier<V> var2);

    private static class SerialProducerGuard<T>
    extends ProducerGuard<T> {
        private final Lock lock = new ReentrantLock();

        private SerialProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            try {
                this.lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class StripedProducerGuard<T>
    extends ProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class AdaptiveProducerGuard<T>
    extends ProducerGuard<T> {
        private final Set<T> producing = new HashSet<T>();

        private AdaptiveProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Set<Object> set = this.producing;
            synchronized (set) {
                while (!this.producing.add(key)) {
                    try {
                        this.producing.wait();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            }
            try {
                set = supplier.get();
                return (V)set;
            }
            finally {
                Set<T> set2 = this.producing;
                synchronized (set2) {
                    this.producing.remove(key);
                    this.producing.notifyAll();
                }
            }
        }
    }
}

