/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.ProblemCategory;
import org.gradle.api.problems.internal.ProblemLocation;

@NonNullApi
public class DefaultProblem
implements InternalProblem,
Serializable {
    private final String label;
    private Severity severity;
    private final List<ProblemLocation> locations;
    private final DocLink documentationLink;
    private final String description;
    private final List<String> solutions;
    private final RuntimeException cause;
    private final ProblemCategory problemCategory;
    private final Map<String, Object> additionalData;

    protected DefaultProblem(String label, Severity severity, List<ProblemLocation> locations, @Nullable DocLink documentationUrl, @Nullable String description, @Nullable List<String> solutions, @Nullable RuntimeException cause, ProblemCategory problemCategory, Map<String, Object> additionalData) {
        this.label = label;
        this.severity = severity;
        this.locations = ImmutableList.copyOf(locations);
        this.documentationLink = documentationUrl;
        this.description = description;
        this.solutions = solutions == null ? ImmutableList.of() : ImmutableList.copyOf(solutions);
        this.cause = cause;
        this.problemCategory = problemCategory;
        this.additionalData = ImmutableMap.copyOf(additionalData);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public List<ProblemLocation> getLocations() {
        return this.locations;
    }

    @Override
    @Nullable
    public DocLink getDocumentationLink() {
        return this.documentationLink;
    }

    @Override
    public String getDetails() {
        return this.description;
    }

    @Override
    public List<String> getSolutions() {
        return this.solutions;
    }

    @Override
    public RuntimeException getException() {
        return this.cause;
    }

    @Override
    public ProblemCategory getCategory() {
        return this.problemCategory;
    }

    @Override
    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Override
    public InternalProblemBuilder toBuilder() {
        return new DefaultProblemBuilder(this);
    }

    private static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblem that = (DefaultProblem)o;
        return DefaultProblem.equals(this.label, that.label) && this.severity == that.severity && DefaultProblem.equals(this.locations, that.locations) && DefaultProblem.equals(this.problemCategory, that.problemCategory) && DefaultProblem.equals(this.documentationLink, that.documentationLink) && DefaultProblem.equals(this.description, that.description) && DefaultProblem.equals(this.solutions, that.solutions) && DefaultProblem.equals(this.cause, that.cause) && DefaultProblem.equals(this.additionalData, that.additionalData);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.label, this.severity, this.locations, this.documentationLink, this.description, this.solutions, this.cause, this.additionalData});
    }
}

